/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaWithTypeVisitor;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.data.avro.DecoderResolver;
import org.apache.iceberg.flink.data.FlinkValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class FlinkAvroReader
implements DatumReader<RowData> {
    private final org.apache.iceberg.shaded.org.apache.avro.Schema readSchema;
    private final ValueReader<RowData> reader;
    private org.apache.iceberg.shaded.org.apache.avro.Schema fileSchema = null;

    public FlinkAvroReader(Schema expectedSchema, org.apache.iceberg.shaded.org.apache.avro.Schema readSchema) {
        this(expectedSchema, readSchema, ImmutableMap.of());
    }

    public FlinkAvroReader(Schema expectedSchema, org.apache.iceberg.shaded.org.apache.avro.Schema readSchema, Map<Integer, ?> constants) {
        this.readSchema = readSchema;
        this.reader = (ValueReader)AvroSchemaWithTypeVisitor.visit(expectedSchema, readSchema, new ReadBuilder(constants));
    }

    @Override
    public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema newFileSchema) {
        this.fileSchema = org.apache.iceberg.shaded.org.apache.avro.Schema.applyAliases(newFileSchema, this.readSchema);
    }

    @Override
    public RowData read(RowData reuse, Decoder decoder) throws IOException {
        return DecoderResolver.resolveAndRead(decoder, this.readSchema, this.fileSchema, this.reader, reuse);
    }

    private static class ReadBuilder
    extends AvroSchemaWithTypeVisitor<ValueReader<?>> {
        private final Map<Integer, ?> idToConstant;

        private ReadBuilder(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        @Override
        public ValueReader<?> record(Types.StructType expected, org.apache.iceberg.shaded.org.apache.avro.Schema record, List<String> names, List<ValueReader<?>> fields) {
            return FlinkValueReaders.struct(fields, expected.asStructType(), this.idToConstant);
        }

        @Override
        public ValueReader<?> union(Type expected, org.apache.iceberg.shaded.org.apache.avro.Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> array(Types.ListType expected, org.apache.iceberg.shaded.org.apache.avro.Schema array, ValueReader<?> elementReader) {
            return FlinkValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Types.MapType expected, org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueReader<?> keyReader, ValueReader<?> valueReader) {
            return FlinkValueReaders.arrayMap(keyReader, valueReader);
        }

        @Override
        public ValueReader<?> map(Types.MapType expected, org.apache.iceberg.shaded.org.apache.avro.Schema map, ValueReader<?> valueReader) {
            return FlinkValueReaders.map(FlinkValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> primitive(Type.PrimitiveType expected, org.apache.iceberg.shaded.org.apache.avro.Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "time-micros": {
                        return FlinkValueReaders.timeMicros();
                    }
                    case "timestamp-millis": {
                        return FlinkValueReaders.timestampMills();
                    }
                    case "timestamp-micros": {
                        return FlinkValueReaders.timestampMicros();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return FlinkValueReaders.decimal(ValueReaders.decimalBytesReader(primitive), decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return FlinkValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return FlinkValueReaders.strings();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueReaders.bytes();
                }
                case ENUM: {
                    return FlinkValueReaders.enums(primitive.getEnumSymbols());
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

