/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;

class FlinkOrcWriters {
    private FlinkOrcWriters() {
    }

    static OrcValueWriter<StringData> strings() {
        return StringWriter.INSTANCE;
    }

    static OrcValueWriter<Integer> dates() {
        return DateWriter.INSTANCE;
    }

    static OrcValueWriter<Integer> times() {
        return TimeWriter.INSTANCE;
    }

    static OrcValueWriter<TimestampData> timestamps() {
        return TimestampWriter.INSTANCE;
    }

    static OrcValueWriter<TimestampData> timestampTzs() {
        return TimestampTzWriter.INSTANCE;
    }

    static OrcValueWriter<DecimalData> decimals(int precision, int scale) {
        if (precision <= 18) {
            return new Decimal18Writer(precision, scale);
        }
        if (precision <= 38) {
            return new Decimal38Writer(precision, scale);
        }
        throw new IllegalArgumentException("Invalid precision: " + precision);
    }

    static <T> OrcValueWriter<ArrayData> list(OrcValueWriter<T> elementWriter, LogicalType elementType) {
        return new ListWriter<T>(elementWriter, elementType);
    }

    static <K, V> OrcValueWriter<MapData> map(OrcValueWriter<K> keyWriter, OrcValueWriter<V> valueWriter, LogicalType keyType, LogicalType valueType) {
        return new MapWriter<K, V>(keyWriter, valueWriter, keyType, valueType);
    }

    static OrcValueWriter<RowData> struct(List<OrcValueWriter<?>> writers, List<LogicalType> types) {
        return new StructWriter(writers, types);
    }

    static class StructWriter
    implements OrcValueWriter<RowData> {
        private final List<OrcValueWriter<?>> writers;
        private final List<RowData.FieldGetter> fieldGetters;

        StructWriter(List<OrcValueWriter<?>> writers, List<LogicalType> types) {
            this.writers = writers;
            this.fieldGetters = Lists.newArrayListWithExpectedSize(types.size());
            for (int i = 0; i < types.size(); ++i) {
                this.fieldGetters.add(RowData.createFieldGetter((LogicalType)types.get(i), (int)i));
            }
        }

        List<OrcValueWriter<?>> writers() {
            return this.writers;
        }

        @Override
        public Class<?> getJavaClass() {
            return RowData.class;
        }

        @Override
        public void nonNullWrite(int rowId, RowData data, ColumnVector output) {
            StructColumnVector cv = (StructColumnVector)output;
            for (int c = 0; c < this.writers.size(); ++c) {
                OrcValueWriter<?> writer = this.writers.get(c);
                writer.write(rowId, this.fieldGetters.get(c).getFieldOrNull(data), cv.fields[c]);
            }
        }
    }

    static class MapWriter<K, V>
    implements OrcValueWriter<MapData> {
        private final OrcValueWriter<K> keyWriter;
        private final OrcValueWriter<V> valueWriter;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        MapWriter(OrcValueWriter<K> keyWriter, OrcValueWriter<V> valueWriter, LogicalType keyType, LogicalType valueType) {
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
            this.keyGetter = ArrayData.createElementGetter((LogicalType)keyType);
            this.valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        }

        @Override
        public Class<?> getJavaClass() {
            return MapData.class;
        }

        @Override
        public void nonNullWrite(int rowId, MapData data, ColumnVector output) {
            MapColumnVector cv = (MapColumnVector)output;
            ArrayData keyArray = data.keyArray();
            ArrayData valArray = data.valueArray();
            cv.lengths[rowId] = data.size();
            cv.offsets[rowId] = cv.childCount;
            cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
            cv.keys.ensureSize(cv.childCount, true);
            cv.values.ensureSize(cv.childCount, true);
            int e = 0;
            while ((long)e < cv.lengths[rowId]) {
                int pos = (int)((long)e + cv.offsets[rowId]);
                this.keyWriter.write(pos, this.keyGetter.getElementOrNull(keyArray, e), cv.keys);
                this.valueWriter.write(pos, this.valueGetter.getElementOrNull(valArray, e), cv.values);
                ++e;
            }
        }
    }

    static class ListWriter<T>
    implements OrcValueWriter<ArrayData> {
        private final OrcValueWriter<T> elementWriter;
        private final ArrayData.ElementGetter elementGetter;

        ListWriter(OrcValueWriter<T> elementWriter, LogicalType elementType) {
            this.elementWriter = elementWriter;
            this.elementGetter = ArrayData.createElementGetter((LogicalType)elementType);
        }

        @Override
        public Class<?> getJavaClass() {
            return ArrayData.class;
        }

        @Override
        public void nonNullWrite(int rowId, ArrayData data, ColumnVector output) {
            ListColumnVector cv = (ListColumnVector)output;
            cv.lengths[rowId] = data.size();
            cv.offsets[rowId] = cv.childCount;
            cv.childCount = (int)((long)cv.childCount + cv.lengths[rowId]);
            cv.child.ensureSize(cv.childCount, true);
            int e = 0;
            while ((long)e < cv.lengths[rowId]) {
                Object value = this.elementGetter.getElementOrNull(data, e);
                this.elementWriter.write((int)((long)e + cv.offsets[rowId]), value, cv.child);
                ++e;
            }
        }
    }

    private static class Decimal38Writer
    implements OrcValueWriter<DecimalData> {
        private final int precision;
        private final int scale;

        Decimal38Writer(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public Class<?> getJavaClass() {
            return DecimalData.class;
        }

        @Override
        public void nonNullWrite(int rowId, DecimalData data, ColumnVector output) {
            Preconditions.checkArgument(this.scale == data.scale(), "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)data);
            Preconditions.checkArgument(data.precision() <= this.precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)data);
            ((DecimalColumnVector)output).vector[rowId].set(HiveDecimal.create(data.toBigDecimal(), false));
        }
    }

    private static class Decimal18Writer
    implements OrcValueWriter<DecimalData> {
        private final int precision;
        private final int scale;

        Decimal18Writer(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public Class<?> getJavaClass() {
            return DecimalData.class;
        }

        @Override
        public void nonNullWrite(int rowId, DecimalData data, ColumnVector output) {
            Preconditions.checkArgument(this.scale == data.scale(), "Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)data);
            Preconditions.checkArgument(data.precision() <= this.precision, "Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)data);
            ((DecimalColumnVector)output).vector[rowId].setFromLongAndScale(data.toUnscaledLong(), data.scale());
        }
    }

    private static class TimestampTzWriter
    implements OrcValueWriter<TimestampData> {
        private static final TimestampTzWriter INSTANCE = new TimestampTzWriter();

        private TimestampTzWriter() {
        }

        @Override
        public Class<TimestampData> getJavaClass() {
            return TimestampData.class;
        }

        @Override
        public void nonNullWrite(int rowId, TimestampData data, ColumnVector output) {
            TimestampColumnVector cv = (TimestampColumnVector)output;
            Instant instant = data.toInstant();
            cv.time[rowId] = instant.toEpochMilli();
            cv.nanos[rowId] = instant.getNano() / 1000 * 1000;
        }
    }

    private static class TimestampWriter
    implements OrcValueWriter<TimestampData> {
        private static final TimestampWriter INSTANCE = new TimestampWriter();

        private TimestampWriter() {
        }

        @Override
        public Class<?> getJavaClass() {
            return TimestampData.class;
        }

        @Override
        public void nonNullWrite(int rowId, TimestampData data, ColumnVector output) {
            TimestampColumnVector cv = (TimestampColumnVector)output;
            cv.setIsUTC(true);
            OffsetDateTime offsetDateTime = data.toInstant().atOffset(ZoneOffset.UTC);
            cv.time[rowId] = offsetDateTime.toEpochSecond() * 1000L + (long)(offsetDateTime.getNano() / 1000000);
            cv.nanos[rowId] = offsetDateTime.getNano() / 1000 * 1000;
        }
    }

    private static class TimeWriter
    implements OrcValueWriter<Integer> {
        private static final TimeWriter INSTANCE = new TimeWriter();

        private TimeWriter() {
        }

        @Override
        public Class<?> getJavaClass() {
            return Integer.class;
        }

        @Override
        public void nonNullWrite(int rowId, Integer millis, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = (long)millis.intValue() * 1000L;
        }
    }

    private static class DateWriter
    implements OrcValueWriter<Integer> {
        private static final DateWriter INSTANCE = new DateWriter();

        private DateWriter() {
        }

        @Override
        public Class<?> getJavaClass() {
            return Integer.class;
        }

        @Override
        public void nonNullWrite(int rowId, Integer data, ColumnVector output) {
            ((LongColumnVector)output).vector[rowId] = data.intValue();
        }
    }

    private static class StringWriter
    implements OrcValueWriter<StringData> {
        private static final StringWriter INSTANCE = new StringWriter();

        private StringWriter() {
        }

        @Override
        public Class<?> getJavaClass() {
            return StringData.class;
        }

        @Override
        public void nonNullWrite(int rowId, StringData data, ColumnVector output) {
            byte[] value = data.toBytes();
            ((BytesColumnVector)output).setRef(rowId, value, 0, value.length);
        }
    }
}

