/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class FlinkManifestSerializer
implements SimpleVersionedSerializer<ManifestFile> {
    private static final int VERSION_NUM = 1;
    static final FlinkManifestSerializer INSTANCE = new FlinkManifestSerializer();

    FlinkManifestSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(ManifestFile manifestFile) throws IOException {
        Preconditions.checkNotNull(manifestFile, "ManifestFile to be serialized should not be null");
        return ManifestFiles.encode(manifestFile);
    }

    public ManifestFile deserialize(int version, byte[] serialized) throws IOException {
        return ManifestFiles.decode(serialized);
    }
}

