/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.source.FlinkInputSplit;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class FlinkSplitGenerator {
    private FlinkSplitGenerator() {
    }

    static FlinkInputSplit[] createInputSplits(Table table, ScanContext context) {
        List<CombinedScanTask> tasks = FlinkSplitGenerator.tasks(table, context);
        FlinkInputSplit[] splits = new FlinkInputSplit[tasks.size()];
        for (int i = 0; i < tasks.size(); ++i) {
            splits[i] = new FlinkInputSplit(i, tasks.get(i));
        }
        return splits;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<CombinedScanTask> tasks(Table table, ScanContext context) {
        TableScan scan = table.newScan().caseSensitive(context.caseSensitive()).project(context.projectedSchema());
        if (context.snapshotId() != null) {
            scan = scan.useSnapshot(context.snapshotId());
        }
        if (context.asOfTimestamp() != null) {
            scan = scan.asOfTime(context.asOfTimestamp());
        }
        if (context.startSnapshotId() != null) {
            scan = context.endSnapshotId() != null ? scan.appendsBetween(context.startSnapshotId(), context.endSnapshotId()) : scan.appendsAfter(context.startSnapshotId());
        }
        if (context.splitSize() != null) {
            scan = scan.option("read.split.target-size", context.splitSize().toString());
        }
        if (context.splitLookback() != null) {
            scan = scan.option("read.split.planning-lookback", context.splitLookback().toString());
        }
        if (context.splitOpenFileCost() != null) {
            scan = scan.option("read.split.open-file-cost", context.splitOpenFileCost().toString());
        }
        if (context.filterExpressions() != null) {
            for (Expression filter : context.filterExpressions()) {
                scan = scan.filter(filter);
            }
        }
        try (CloseableIterable<CombinedScanTask> tasksIterable = scan.planTasks();){
            ArrayList<CombinedScanTask> arrayList = Lists.newArrayList(tasksIterable);
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close table scan: " + scan, e);
        }
    }
}

