/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class HadoopCatalog
extends BaseMetastoreCatalog
implements Closeable,
SupportsNamespaces {
    private static final String ICEBERG_HADOOP_WAREHOUSE_BASE = "iceberg/warehouse";
    private static final String TABLE_METADATA_FILE_EXTENSION = ".metadata.json";
    private static final Joiner SLASH = Joiner.on("/");
    private static final PathFilter TABLE_FILTER = path -> path.getName().endsWith(TABLE_METADATA_FILE_EXTENSION);
    private final String catalogName;
    private final Configuration conf;
    private final String warehouseLocation;
    private final FileSystem fs;

    public HadoopCatalog(String name, Configuration conf, String warehouseLocation) {
        Preconditions.checkArgument(warehouseLocation != null && !warehouseLocation.equals(""), "no location provided for warehouse");
        this.catalogName = name;
        this.conf = conf;
        this.warehouseLocation = warehouseLocation.replaceAll("/*$", "");
        this.fs = Util.getFs(new Path(warehouseLocation), conf);
    }

    public HadoopCatalog(Configuration conf, String warehouseLocation) {
        this("hadoop", conf, warehouseLocation);
    }

    public HadoopCatalog(Configuration conf) {
        this("hadoop", conf, conf.get("fs.defaultFS") + "/" + ICEBERG_HADOOP_WAREHOUSE_BASE);
    }

    @Override
    public String name() {
        return this.catalogName;
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        Preconditions.checkArgument(namespace.levels().length >= 1, "Missing database in table identifier: %s", (Object)namespace);
        Path nsPath = new Path(this.warehouseLocation, SLASH.join(namespace.levels()));
        HashSet<TableIdentifier> tblIdents = Sets.newHashSet();
        try {
            if (!this.fs.exists(nsPath) || !this.fs.isDirectory(nsPath)) {
                throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
            }
            for (FileStatus s2 : this.fs.listStatus(nsPath)) {
                Path metadataPath;
                Path path = s2.getPath();
                if (!this.fs.isDirectory(path) || !this.fs.exists(metadataPath = new Path(path, "metadata")) || !this.fs.isDirectory(metadataPath) || this.fs.listStatus(metadataPath, TABLE_FILTER).length < 1) continue;
                TableIdentifier tblIdent = TableIdentifier.of(namespace, path.getName());
                tblIdents.add(tblIdent);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to list tables under: %s", namespace);
        }
        return Lists.newArrayList(tblIdents);
    }

    @Override
    protected boolean isValidIdentifier(TableIdentifier identifier) {
        return true;
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier identifier) {
        return new HadoopTableOperations(new Path(this.defaultWarehouseLocation(identifier)), this.conf);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        String tableName = tableIdentifier.name();
        StringBuilder sb = new StringBuilder();
        sb.append(this.warehouseLocation).append('/');
        for (String level : tableIdentifier.namespace().levels()) {
            sb.append(level).append('/');
        }
        sb.append(tableName);
        return sb.toString();
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        if (!this.isValidIdentifier(identifier)) {
            throw new NoSuchTableException("Invalid identifier: %s", identifier);
        }
        Path tablePath = new Path(this.defaultWarehouseLocation(identifier));
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        try {
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData(ops.io(), lastMetadata);
            }
            this.fs.delete(tablePath, true);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to delete file: %s", tablePath);
        }
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier to) {
        throw new UnsupportedOperationException("Cannot rename Hadoop tables");
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> meta) {
        Preconditions.checkArgument(!namespace.isEmpty(), "Cannot create namespace with invalid name: %s", (Object)namespace);
        if (!meta.isEmpty()) {
            throw new UnsupportedOperationException("Cannot create namespace " + namespace + ": metadata is not supported");
        }
        Path nsPath = new Path(this.warehouseLocation, SLASH.join(namespace.levels()));
        if (this.isNamespace(nsPath)) {
            throw new AlreadyExistsException("Namespace already exists: %s", namespace);
        }
        try {
            this.fs.mkdirs(nsPath);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Create namespace failed: %s", namespace);
        }
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) {
        Path nsPath;
        Path path2 = nsPath = namespace.isEmpty() ? new Path(this.warehouseLocation) : new Path(this.warehouseLocation, SLASH.join(namespace.levels()));
        if (!this.isNamespace(nsPath)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        try {
            return Stream.of(this.fs.listStatus(nsPath)).map(FileStatus::getPath).filter(this::isNamespace).map(path -> this.append(namespace, path.getName())).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to list namespace under: %s", namespace);
        }
    }

    private Namespace append(Namespace ns, String name) {
        String[] levels = Arrays.copyOfRange(ns.levels(), 0, ns.levels().length + 1);
        levels[ns.levels().length] = name;
        return Namespace.of(levels);
    }

    @Override
    public boolean dropNamespace(Namespace namespace) {
        Path nsPath = new Path(this.warehouseLocation, SLASH.join(namespace.levels()));
        if (!this.isNamespace(nsPath) || namespace.isEmpty()) {
            return false;
        }
        try {
            if (this.fs.listStatusIterator(nsPath).hasNext()) {
                throw new NamespaceNotEmptyException("Namespace %s is not empty.", namespace);
            }
            return this.fs.delete(nsPath, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Namespace delete failed: %s", namespace);
        }
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        throw new UnsupportedOperationException("Cannot set namespace properties " + namespace + " : setProperties is not supported");
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        throw new UnsupportedOperationException("Cannot remove properties " + namespace + " : removeProperties is not supported");
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) {
        Path nsPath = new Path(this.warehouseLocation, SLASH.join(namespace.levels()));
        if (!this.isNamespace(nsPath) || namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        return ImmutableMap.of("location", nsPath.toString());
    }

    private boolean isNamespace(Path path) {
        Path metadataPath = new Path(path, "metadata");
        try {
            return this.fs.isDirectory(path) && (!this.fs.exists(metadataPath) || !this.fs.isDirectory(metadataPath) || this.fs.listStatus(metadataPath, TABLE_FILTER).length < 1);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to list namespace info: %s ", path);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.catalogName).add("location", this.warehouseLocation).toString();
    }

    @Override
    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new HadoopCatalogTableBuilder(identifier, schema);
    }

    private class HadoopCatalogTableBuilder
    extends BaseMetastoreCatalog.BaseMetastoreCatalogTableBuilder {
        private HadoopCatalogTableBuilder(TableIdentifier identifier, Schema schema) {
            super(identifier, schema);
        }

        @Override
        public Catalog.TableBuilder withLocation(String location) {
            Preconditions.checkArgument(location == null, "Cannot set a custom location for a path-based table");
            return this;
        }
    }
}

