/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopTableOperations
implements TableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopTableOperations.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("v([^\\.]*)\\..*");
    private final Configuration conf;
    private final Path location;
    private HadoopFileIO defaultFileIo = null;
    private volatile TableMetadata currentMetadata = null;
    private volatile Integer version = null;
    private volatile boolean shouldRefresh = true;

    protected HadoopTableOperations(Path location, Configuration conf) {
        this.conf = conf;
        this.location = location;
    }

    @Override
    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    private synchronized Pair<Integer, TableMetadata> versionAndMetadata() {
        return Pair.of(this.version, this.currentMetadata);
    }

    private synchronized void updateVersionAndMetadata(int newVersion, String metadataFile) {
        if (this.version == null || this.version != newVersion) {
            this.version = newVersion;
            this.currentMetadata = HadoopTableOperations.checkUUID(this.currentMetadata, TableMetadataParser.read(this.io(), metadataFile));
        }
    }

    @Override
    public TableMetadata refresh() {
        int ver = this.version != null ? this.version.intValue() : this.findVersion();
        try {
            Path metadataFile = this.getMetadataFile(ver);
            if (this.version == null && metadataFile == null && ver == 0) {
                return null;
            }
            if (metadataFile == null) {
                throw new ValidationException("Metadata file for version %d is missing", ver);
            }
            Path nextMetadataFile = this.getMetadataFile(ver + 1);
            while (nextMetadataFile != null) {
                metadataFile = nextMetadataFile;
                nextMetadataFile = this.getMetadataFile(++ver + 1);
            }
            this.updateVersionAndMetadata(ver, metadataFile.toString());
            this.shouldRefresh = false;
            return this.currentMetadata;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to refresh the table", new Object[0]);
        }
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        Pair<Integer, TableMetadata> current = this.versionAndMetadata();
        if (base != current.second()) {
            throw new CommitFailedException("Cannot commit changes based on stale table metadata", new Object[0]);
        }
        if (base == metadata) {
            LOG.info("Nothing to commit.");
            return;
        }
        Preconditions.checkArgument(base == null || base.location().equals(metadata.location()), "Hadoop path-based tables cannot be relocated");
        Preconditions.checkArgument(!metadata.properties().containsKey("write.metadata.path"), "Hadoop path-based tables cannot relocate metadata");
        String codecName = metadata.property("write.metadata.compression-codec", "none");
        TableMetadataParser.Codec codec = TableMetadataParser.Codec.fromName(codecName);
        String fileExtension = TableMetadataParser.getFileExtension(codec);
        Path tempMetadataFile = this.metadataPath(UUID.randomUUID().toString() + fileExtension);
        TableMetadataParser.write(metadata, this.io().newOutputFile(tempMetadataFile.toString()));
        int nextVersion = (current.first() != null ? current.first() : 0) + 1;
        Path finalMetadataFile = this.metadataFilePath(nextVersion, codec);
        FileSystem fs = this.getFileSystem(tempMetadataFile, this.conf);
        try {
            if (fs.exists(finalMetadataFile)) {
                throw new CommitFailedException("Version %d already exists: %s", nextVersion, finalMetadataFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to check if next version exists: %s", finalMetadataFile);
        }
        this.renameToFinal(fs, tempMetadataFile, finalMetadataFile);
        this.writeVersionHint(nextVersion);
        this.deleteRemovedMetadataFiles(base, metadata);
        this.shouldRefresh = true;
    }

    @Override
    public FileIO io() {
        if (this.defaultFileIo == null) {
            this.defaultFileIo = new HadoopFileIO(this.conf);
        }
        return this.defaultFileIo;
    }

    @Override
    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor(this.current().location(), this.current().properties());
    }

    @Override
    public String metadataFileLocation(String fileName) {
        return this.metadataPath(fileName).toString();
    }

    @Override
    public TableOperations temp(final TableMetadata uncommittedMetadata) {
        return new TableOperations(){

            @Override
            public TableMetadata current() {
                return uncommittedMetadata;
            }

            @Override
            public TableMetadata refresh() {
                throw new UnsupportedOperationException("Cannot call refresh on temporary table operations");
            }

            @Override
            public void commit(TableMetadata base, TableMetadata metadata) {
                throw new UnsupportedOperationException("Cannot call commit on temporary table operations");
            }

            @Override
            public String metadataFileLocation(String fileName) {
                return HadoopTableOperations.this.metadataFileLocation(fileName);
            }

            @Override
            public LocationProvider locationProvider() {
                return LocationProviders.locationsFor(uncommittedMetadata.location(), uncommittedMetadata.properties());
            }

            @Override
            public FileIO io() {
                return HadoopTableOperations.this.io();
            }

            @Override
            public EncryptionManager encryption() {
                return HadoopTableOperations.this.encryption();
            }

            @Override
            public long newSnapshotId() {
                return HadoopTableOperations.this.newSnapshotId();
            }
        };
    }

    @VisibleForTesting
    Path getMetadataFile(int metadataVersion) throws IOException {
        for (TableMetadataParser.Codec codec : TableMetadataParser.Codec.values()) {
            Path metadataFile = this.metadataFilePath(metadataVersion, codec);
            FileSystem fs = this.getFileSystem(metadataFile, this.conf);
            if (fs.exists(metadataFile)) {
                return metadataFile;
            }
            if (!codec.equals((Object)TableMetadataParser.Codec.GZIP) || !(fs = this.getFileSystem(metadataFile = this.oldMetadataFilePath(metadataVersion, codec), this.conf)).exists(metadataFile)) continue;
            return metadataFile;
        }
        return null;
    }

    private Path metadataFilePath(int metadataVersion, TableMetadataParser.Codec codec) {
        return this.metadataPath("v" + metadataVersion + TableMetadataParser.getFileExtension(codec));
    }

    private Path oldMetadataFilePath(int metadataVersion, TableMetadataParser.Codec codec) {
        return this.metadataPath("v" + metadataVersion + TableMetadataParser.getOldFileExtension(codec));
    }

    private Path metadataPath(String filename) {
        return new Path(this.metadataRoot(), filename);
    }

    private Path metadataRoot() {
        return new Path(this.location, "metadata");
    }

    private int version(String fileName) {
        Matcher matcher = VERSION_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return -1;
        }
        String versionNumber = matcher.group(1);
        try {
            return Integer.parseInt(versionNumber);
        }
        catch (NumberFormatException ne) {
            return -1;
        }
    }

    @VisibleForTesting
    Path versionHintFile() {
        return this.metadataPath("version-hint.text");
    }

    private void writeVersionHint(int versionToWrite) {
        Path versionHintFile = this.versionHintFile();
        FileSystem fs = this.getFileSystem(versionHintFile, this.conf);
        try {
            Path tempVersionHintFile = this.metadataPath(UUID.randomUUID().toString() + "-version-hint.temp");
            this.writeVersionToPath(fs, tempVersionHintFile, versionToWrite);
            fs.delete(versionHintFile, false);
            fs.rename(tempVersionHintFile, versionHintFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to update version hint", (Throwable)e);
        }
    }

    private void writeVersionToPath(FileSystem fs, Path path, int versionToWrite) throws IOException {
        try (FSDataOutputStream out = fs.create(path, false);){
            out.write(String.valueOf(versionToWrite).getBytes(StandardCharsets.UTF_8));
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    int findVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void renameToFinal(FileSystem fs, Path src, Path dst) {
        try {
            if (!fs.rename(src, dst)) {
                CommitFailedException cfe = new CommitFailedException("Failed to commit changes using rename: %s", dst);
                RuntimeException re = this.tryDelete(src);
                if (re != null) {
                    cfe.addSuppressed(re);
                }
                throw cfe;
            }
        }
        catch (IOException e) {
            CommitFailedException cfe = new CommitFailedException(e, "Failed to commit changes using rename: %s", dst);
            RuntimeException re = this.tryDelete(src);
            if (re != null) {
                cfe.addSuppressed(re);
            }
            throw cfe;
        }
    }

    private RuntimeException tryDelete(Path path) {
        try {
            this.io().deleteFile(path.toString());
            return null;
        }
        catch (RuntimeException re) {
            return re;
        }
    }

    protected FileSystem getFileSystem(Path path, Configuration hadoopConf) {
        return Util.getFs(path, hadoopConf);
    }

    private void deleteRemovedMetadataFiles(TableMetadata base, TableMetadata metadata) {
        if (base == null) {
            return;
        }
        boolean deleteAfterCommit = metadata.propertyAsBoolean("write.metadata.delete-after-commit.enabled", false);
        HashSet<TableMetadata.MetadataLogEntry> removedPreviousMetadataFiles = Sets.newHashSet(base.previousFiles());
        removedPreviousMetadataFiles.removeAll(metadata.previousFiles());
        if (deleteAfterCommit) {
            Tasks.foreach(removedPreviousMetadataFiles).noRetry().suppressFailureWhenFinished().onFailure((previousMetadataFile, exc) -> LOG.warn("Delete failed for previous metadata file: {}", previousMetadataFile, (Object)exc)).run(previousMetadataFile -> this.io().deleteFile(previousMetadataFile.file()));
        }
    }

    private static TableMetadata checkUUID(TableMetadata currentMetadata, TableMetadata newMetadata) {
        String newUUID = newMetadata.uuid();
        if (currentMetadata != null && currentMetadata.uuid() != null && newUUID != null) {
            Preconditions.checkState(newUUID.equals(currentMetadata.uuid()), "Table UUID does not match: current=%s != refreshed=%s", (Object)currentMetadata.uuid(), (Object)newUUID);
        }
        return newMetadata;
    }

    private static /* synthetic */ boolean lambda$findVersion$0(Path name) {
        return VERSION_PATTERN.matcher(name.getName()).matches();
    }
}

