/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.hive.ClientPool;
import org.apache.iceberg.hive.RuntimeMetaException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class HiveClientPool
extends ClientPool<HiveMetaStoreClient, TException> {
    private static final DynConstructors.Ctor<HiveMetaStoreClient> CLIENT_CTOR = DynConstructors.builder().impl(HiveMetaStoreClient.class, HiveConf.class).impl(HiveMetaStoreClient.class, Configuration.class).build();
    private final HiveConf hiveConf;

    HiveClientPool(Configuration conf) {
        this(conf.getInt("iceberg.hive.client-pool-size", 5), conf);
    }

    public HiveClientPool(int poolSize, Configuration conf) {
        super(poolSize, TTransportException.class);
        this.hiveConf = new HiveConf(conf, HiveClientPool.class);
    }

    @Override
    protected HiveMetaStoreClient newClient() {
        try {
            try {
                return CLIENT_CTOR.newInstance(this.hiveConf);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof MetaException) {
                    throw (MetaException)e.getCause();
                }
                throw e;
            }
        }
        catch (MetaException e) {
            throw new RuntimeMetaException(e, "Failed to connect to Hive Metastore", new Object[0]);
        }
        catch (Throwable t) {
            if (t.getMessage().contains("Another instance of Derby may have already booted")) {
                throw new RuntimeMetaException(t, "Failed to start an embedded metastore because embedded Derby supports only one client at a time. To fix this, use a metastore that supports multiple clients.", new Object[0]);
            }
            throw new RuntimeMetaException(t, "Failed to connect to Hive Metastore", new Object[0]);
        }
    }

    @Override
    protected HiveMetaStoreClient reconnect(HiveMetaStoreClient client) {
        try {
            client.close();
            client.reconnect();
        }
        catch (MetaException e) {
            throw new RuntimeMetaException(e, "Failed to reconnect to Hive Metastore", new Object[0]);
        }
        return client;
    }

    @Override
    protected void close(HiveMetaStoreClient client) {
        client.close();
    }
}

