/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex;

import java.util.Formatter;
import org.apache.iceberg.shaded.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.ints.IntList;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.iceberg.shaded.org.apache.parquet.shaded.it.unimi.dsi.fastutil.longs.LongList;

public class OffsetIndexBuilder {
    private static final OffsetIndexBuilder NO_OP_BUILDER = new OffsetIndexBuilder(){

        @Override
        public void add(int compressedPageSize, long rowCount) {
        }

        @Override
        public void add(long offset, int compressedPageSize, long rowCount) {
        }
    };
    private final LongList offsets = new LongArrayList();
    private final IntList compressedPageSizes = new IntArrayList();
    private final LongList firstRowIndexes = new LongArrayList();
    private long previousOffset;
    private int previousPageSize;
    private long previousRowIndex;
    private long previousRowCount;

    public static OffsetIndexBuilder getNoOpBuilder() {
        return NO_OP_BUILDER;
    }

    public static OffsetIndexBuilder getBuilder() {
        return new OffsetIndexBuilder();
    }

    private OffsetIndexBuilder() {
    }

    public void add(int compressedPageSize, long rowCount) {
        this.add(this.previousOffset + (long)this.previousPageSize, compressedPageSize, this.previousRowIndex + this.previousRowCount);
        this.previousRowCount = rowCount;
    }

    public void add(long offset, int compressedPageSize, long firstRowIndex) {
        this.previousOffset = offset;
        this.offsets.add(offset);
        this.previousPageSize = compressedPageSize;
        this.compressedPageSizes.add(compressedPageSize);
        this.previousRowIndex = firstRowIndex;
        this.firstRowIndexes.add(firstRowIndex);
    }

    public OffsetIndex build() {
        return this.build(0L);
    }

    public OffsetIndex build(long firstPageOffset) {
        if (this.compressedPageSizes.isEmpty()) {
            return null;
        }
        long[] offsets = this.offsets.toLongArray();
        if (firstPageOffset != 0L) {
            int i = 0;
            int n = offsets.length;
            while (i < n) {
                int n2 = i++;
                offsets[n2] = offsets[n2] + firstPageOffset;
            }
        }
        OffsetIndexImpl offsetIndex = new OffsetIndexImpl();
        OffsetIndexImpl.access$202(offsetIndex, offsets);
        OffsetIndexImpl.access$302(offsetIndex, this.compressedPageSizes.toIntArray());
        OffsetIndexImpl.access$402(offsetIndex, this.firstRowIndexes.toLongArray());
        return offsetIndex;
    }

    private static class OffsetIndexImpl
    implements OffsetIndex {
        private long[] offsets;
        private int[] compressedPageSizes;
        private long[] firstRowIndexes;

        private OffsetIndexImpl() {
        }

        public String toString() {
            try (Formatter formatter = new Formatter();){
                formatter.format("%-10s  %20s  %16s  %20s\n", "", "offset", "compressed size", "first row index");
                int n = this.offsets.length;
                for (int i = 0; i < n; ++i) {
                    formatter.format("page-%-5d  %20d  %16d  %20d\n", i, this.offsets[i], this.compressedPageSizes[i], this.firstRowIndexes[i]);
                }
                String string = formatter.toString();
                return string;
            }
        }

        @Override
        public int getPageCount() {
            return this.offsets.length;
        }

        @Override
        public long getOffset(int pageIndex) {
            return this.offsets[pageIndex];
        }

        @Override
        public int getCompressedPageSize(int pageIndex) {
            return this.compressedPageSizes[pageIndex];
        }

        @Override
        public long getFirstRowIndex(int pageIndex) {
            return this.firstRowIndexes[pageIndex];
        }

        static /* synthetic */ long[] access$202(OffsetIndexImpl x0, long[] x1) {
            x0.offsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$302(OffsetIndexImpl x0, int[] x1) {
            x0.compressedPageSizes = x1;
            return x1;
        }

        static /* synthetic */ long[] access$402(OffsetIndexImpl x0, long[] x1) {
            x0.firstRowIndexes = x1;
            return x1;
        }
    }
}

