/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;

public interface PartitionSpecVisitor<T> {
    public T identity(String var1, int var2);

    public T bucket(String var1, int var2, int var3);

    public T truncate(String var1, int var2, int var3);

    public T year(String var1, int var2);

    public T month(String var1, int var2);

    public T day(String var1, int var2);

    public T hour(String var1, int var2);

    public static <R> List<R> visit(Schema schema, PartitionSpec spec, PartitionSpecVisitor<R> visitor) {
        ArrayList<R> results = Lists.newArrayListWithExpectedSize(spec.fields().size());
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            Transform<?, ?> transform = field.transform();
            if (transform instanceof Identity) {
                results.add(visitor.identity(sourceName, field.sourceId()));
                continue;
            }
            if (transform instanceof Bucket) {
                results.add(visitor.bucket(sourceName, field.sourceId(), ((Bucket)transform).numBuckets()));
                continue;
            }
            if (transform instanceof Truncate) {
                results.add(visitor.truncate(sourceName, field.sourceId(), ((Truncate)transform).width()));
                continue;
            }
            if (transform == Dates.YEAR || transform == Timestamps.YEAR) {
                results.add(visitor.year(sourceName, field.sourceId()));
                continue;
            }
            if (transform == Dates.MONTH || transform == Timestamps.MONTH) {
                results.add(visitor.month(sourceName, field.sourceId()));
                continue;
            }
            if (transform == Dates.DAY || transform == Timestamps.DAY) {
                results.add(visitor.day(sourceName, field.sourceId()));
                continue;
            }
            if (transform != Timestamps.HOUR) continue;
            results.add(visitor.hour(sourceName, field.sourceId()));
        }
        return results;
    }
}

