/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionUtil {
    private PartitionUtil() {
    }

    public static Map<Integer, ?> constantsMap(FileScanTask task) {
        return PartitionUtil.constantsMap(task, (type, constant) -> constant);
    }

    public static Map<Integer, ?> constantsMap(FileScanTask task, BiFunction<Type, Object, Object> convertConstant) {
        return PartitionUtil.constantsMap(task.spec(), task.file().partition(), convertConstant);
    }

    private static Map<Integer, ?> constantsMap(PartitionSpec spec, StructLike partitionData, BiFunction<Type, Object, Object> convertConstant) {
        HashMap<Integer, Object> idToConstant = new HashMap<Integer, Object>();
        List<Types.NestedField> partitionFields = spec.partitionType().fields();
        List<PartitionField> fields = spec.fields();
        for (int pos = 0; pos < fields.size(); ++pos) {
            PartitionField field = fields.get(pos);
            if (!field.transform().isIdentity()) continue;
            Object converted = convertConstant.apply(partitionFields.get(pos).type(), partitionData.get(pos, Object.class));
            idToConstant.put(field.sourceId(), converted);
        }
        return idToConstant;
    }
}

