/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.transforms.PartitionSpecVisitor;

public class Partitioning {
    private Partitioning() {
    }

    public static boolean hasBucketField(PartitionSpec spec) {
        List<Boolean> bucketList = PartitionSpecVisitor.visit(spec, new PartitionSpecVisitor<Boolean>(){

            @Override
            public Boolean identity(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean bucket(int fieldId, String sourceName, int sourceId, int width) {
                return true;
            }

            @Override
            public Boolean truncate(int fieldId, String sourceName, int sourceId, int width) {
                return false;
            }

            @Override
            public Boolean year(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean month(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean day(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean hour(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean alwaysNull(int fieldId, String sourceName, int sourceId) {
                return false;
            }

            @Override
            public Boolean unknown(int fieldId, String sourceName, int sourceId, String transform) {
                return false;
            }
        });
        return bucketList.stream().anyMatch(Boolean::booleanValue);
    }

    public static SortOrder sortOrderFor(PartitionSpec spec) {
        if (spec.isUnpartitioned()) {
            return SortOrder.unsorted();
        }
        SortOrder.Builder builder = SortOrder.builderFor(spec.schema());
        SpecToOrderVisitor converter = new SpecToOrderVisitor(builder);
        PartitionSpecVisitor.visit(spec, converter);
        String bucketColumn = converter.bucketColumn();
        if (bucketColumn != null) {
            builder.asc(bucketColumn);
        }
        return builder.build();
    }

    private static class SpecToOrderVisitor
    implements PartitionSpecVisitor<Void> {
        private final SortOrder.Builder builder;
        private String bucketColumn = null;
        private int highestNumBuckets = 0;

        private SpecToOrderVisitor(SortOrder.Builder builder) {
            this.builder = builder;
        }

        String bucketColumn() {
            return this.bucketColumn;
        }

        @Override
        public Void identity(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(sourceName);
            return null;
        }

        @Override
        public Void bucket(int fieldId, String sourceName, int sourceId, int numBuckets) {
            if (numBuckets > this.highestNumBuckets) {
                this.highestNumBuckets = numBuckets;
                this.bucketColumn = sourceName;
            }
            this.builder.asc(Expressions.bucket(sourceName, numBuckets));
            return null;
        }

        @Override
        public Void truncate(int fieldId, String sourceName, int sourceId, int width) {
            this.builder.asc(Expressions.truncate(sourceName, width));
            return null;
        }

        @Override
        public Void year(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.year(sourceName));
            return null;
        }

        @Override
        public Void month(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.month(sourceName));
            return null;
        }

        @Override
        public Void day(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.day(sourceName));
            return null;
        }

        @Override
        public Void hour(int fieldId, String sourceName, int sourceId) {
            this.builder.asc(Expressions.hour(sourceName));
            return null;
        }

        @Override
        public Void alwaysNull(int fieldId, String sourceName, int sourceId) {
            return null;
        }
    }
}

