/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.TableScanIterable;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

public class IcebergGenerics {
    private IcebergGenerics() {
    }

    public static ScanBuilder read(Table table) {
        return new ScanBuilder(table);
    }

    public static class ScanBuilder {
        private TableScan tableScan;
        private boolean reuseContainers = false;

        public ScanBuilder(Table table) {
            this.tableScan = table.newScan();
        }

        public ScanBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ScanBuilder where(Expression rowFilter) {
            this.tableScan = this.tableScan.filter(rowFilter);
            return this;
        }

        public ScanBuilder caseInsensitive() {
            this.tableScan = this.tableScan.caseSensitive(false);
            return this;
        }

        public ScanBuilder select(String ... selectedColumns) {
            this.tableScan = this.tableScan.select(ImmutableList.copyOf(selectedColumns));
            return this;
        }

        public ScanBuilder useSnapshot(long scanSnapshotId) {
            this.tableScan = this.tableScan.useSnapshot(scanSnapshotId);
            return this;
        }

        public ScanBuilder asOfTime(long scanTimestampMillis) {
            this.tableScan = this.tableScan.asOfTime(scanTimestampMillis);
            return this;
        }

        public ScanBuilder appendsBetween(long fromSnapshotId, long toSnapshotId) {
            this.tableScan = this.tableScan.appendsBetween(fromSnapshotId, toSnapshotId);
            return this;
        }

        public ScanBuilder appendsAfter(long fromSnapshotId) {
            this.tableScan = this.tableScan.appendsAfter(fromSnapshotId);
            return this;
        }

        public CloseableIterable<Record> build() {
            return new TableScanIterable(this.tableScan, this.reuseContainers);
        }
    }
}

