/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.relocated.com.google.common.collect.MapMaker;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.iceberg.shaded.org.apache.avro.io.ResolvingDecoder;

public class DecoderResolver {
    private static final ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>> DECODER_CACHES = ThreadLocal.withInitial(() -> new MapMaker().weakKeys().makeMap());

    private DecoderResolver() {
    }

    public static <T> T resolveAndRead(Decoder decoder, Schema readSchema, Schema fileSchema, ValueReader<T> reader, T reuse) throws IOException {
        ResolvingDecoder resolver = DecoderResolver.resolve(decoder, readSchema, fileSchema);
        T value = reader.read(resolver, reuse);
        resolver.drain();
        return value;
    }

    private static ResolvingDecoder resolve(Decoder decoder, Schema readSchema, Schema fileSchema) throws IOException {
        Map<Schema, Map<Schema, ResolvingDecoder>> cache = DECODER_CACHES.get();
        Map fileSchemaToResolver = cache.computeIfAbsent(readSchema, k -> new HashMap());
        ResolvingDecoder resolver = fileSchemaToResolver.computeIfAbsent(fileSchema, schema -> DecoderResolver.newResolver(readSchema, schema));
        resolver.configure(decoder);
        return resolver;
    }

    private static ResolvingDecoder newResolver(Schema readSchema, Schema fileSchema) {
        try {
            return DecoderFactory.get().resolvingDecoder(fileSchema, readSchema, null);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

