/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.column.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnWriteStore;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnWriter;
import org.apache.iceberg.shaded.org.apache.parquet.column.ParquetProperties;
import org.apache.iceberg.shaded.org.apache.parquet.column.impl.ColumnWriterBase;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.PageWriteStore;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.PageWriter;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bloomfilter.BloomFilterWriteStore;
import org.apache.iceberg.shaded.org.apache.parquet.column.values.bloomfilter.BloomFilterWriter;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;

abstract class ColumnWriteStoreBase
implements ColumnWriteStore {
    private final ColumnWriterProvider columnWriterProvider;
    private static final float THRESHOLD_TOLERANCE_RATIO = 0.1f;
    private final Map<ColumnDescriptor, ColumnWriterBase> columns;
    private final ParquetProperties props;
    private final long thresholdTolerance;
    private long rowCount;
    private long rowCountForNextSizeCheck;

    @Deprecated
    ColumnWriteStoreBase(final PageWriteStore pageWriteStore, final ParquetProperties props) {
        this.props = props;
        this.thresholdTolerance = (long)((float)props.getPageSizeThreshold() * 0.1f);
        this.columns = new TreeMap<ColumnDescriptor, ColumnWriterBase>();
        this.rowCountForNextSizeCheck = Math.min(props.getMinRowCountForPageSizeCheck(), props.getPageRowCountLimit());
        this.columnWriterProvider = new ColumnWriterProvider(){

            @Override
            public ColumnWriter getColumnWriter(ColumnDescriptor path) {
                ColumnWriterBase column = (ColumnWriterBase)ColumnWriteStoreBase.this.columns.get(path);
                if (column == null) {
                    column = ColumnWriteStoreBase.this.createColumnWriter(path, pageWriteStore.getPageWriter(path), null, props);
                    ColumnWriteStoreBase.this.columns.put(path, column);
                }
                return column;
            }
        };
    }

    ColumnWriteStoreBase(MessageType schema, PageWriteStore pageWriteStore, ParquetProperties props) {
        this.props = props;
        this.thresholdTolerance = (long)((float)props.getPageSizeThreshold() * 0.1f);
        TreeMap<ColumnDescriptor, ColumnWriterBase> mcolumns = new TreeMap<ColumnDescriptor, ColumnWriterBase>();
        for (ColumnDescriptor path : schema.getColumns()) {
            PageWriter pageWriter = pageWriteStore.getPageWriter(path);
            mcolumns.put(path, this.createColumnWriter(path, pageWriter, null, props));
        }
        this.columns = Collections.unmodifiableMap(mcolumns);
        this.rowCountForNextSizeCheck = Math.min(props.getMinRowCountForPageSizeCheck(), props.getPageRowCountLimit());
        this.columnWriterProvider = new ColumnWriterProvider(){

            @Override
            public ColumnWriter getColumnWriter(ColumnDescriptor path) {
                return (ColumnWriter)ColumnWriteStoreBase.this.columns.get(path);
            }
        };
    }

    ColumnWriteStoreBase(MessageType schema, PageWriteStore pageWriteStore, BloomFilterWriteStore bloomFilterWriteStore, ParquetProperties props) {
        this.props = props;
        this.thresholdTolerance = (long)((float)props.getPageSizeThreshold() * 0.1f);
        TreeMap<ColumnDescriptor, ColumnWriterBase> mcolumns = new TreeMap<ColumnDescriptor, ColumnWriterBase>();
        for (ColumnDescriptor path : schema.getColumns()) {
            PageWriter pageWriter = pageWriteStore.getPageWriter(path);
            if (props.isBloomFilterEnabled(path)) {
                BloomFilterWriter bloomFilterWriter = bloomFilterWriteStore.getBloomFilterWriter(path);
                mcolumns.put(path, this.createColumnWriter(path, pageWriter, bloomFilterWriter, props));
                continue;
            }
            mcolumns.put(path, this.createColumnWriter(path, pageWriter, null, props));
        }
        this.columns = Collections.unmodifiableMap(mcolumns);
        this.rowCountForNextSizeCheck = props.getMinRowCountForPageSizeCheck();
        this.columnWriterProvider = new ColumnWriterProvider(){

            @Override
            public ColumnWriter getColumnWriter(ColumnDescriptor path) {
                return (ColumnWriter)ColumnWriteStoreBase.this.columns.get(path);
            }
        };
    }

    abstract ColumnWriterBase createColumnWriter(ColumnDescriptor var1, PageWriter var2, BloomFilterWriter var3, ParquetProperties var4);

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        return this.columnWriterProvider.getColumnWriter(path);
    }

    public Set<ColumnDescriptor> getColumnDescriptors() {
        return this.columns.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterBase> entry : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry.getKey().getPath())).append(": ");
            sb.append(entry.getValue().getTotalBufferedSize()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getAllocatedSize() {
        long total = 0L;
        for (ColumnWriterBase memColumn : this.columns.values()) {
            total += memColumn.allocatedSize();
        }
        return total;
    }

    @Override
    public long getBufferedSize() {
        long total = 0L;
        for (ColumnWriterBase memColumn : this.columns.values()) {
            total += memColumn.getTotalBufferedSize();
        }
        return total;
    }

    @Override
    public void flush() {
        for (ColumnWriterBase memColumn : this.columns.values()) {
            long rows = this.rowCount - memColumn.getRowsWrittenSoFar();
            if (rows > 0L) {
                memColumn.writePage();
            }
            memColumn.finalizeColumnChunk();
        }
    }

    @Override
    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        for (ColumnWriterBase memColumn : this.columns.values()) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }

    public long maxColMemSize() {
        long max = 0L;
        for (ColumnWriterBase memColumn : this.columns.values()) {
            max = Math.max(max, memColumn.getBufferedSizeInMemory());
        }
        return max;
    }

    @Override
    public void close() {
        this.flush();
        for (ColumnWriterBase memColumn : this.columns.values()) {
            memColumn.close();
        }
    }

    @Override
    public void endRecord() {
        ++this.rowCount;
        if (this.rowCount >= this.rowCountForNextSizeCheck) {
            this.sizeCheck();
        }
    }

    private void sizeCheck() {
        long minRecordToWait = Long.MAX_VALUE;
        int pageRowCountLimit = this.props.getPageRowCountLimit();
        long rowCountForNextRowCountCheck = this.rowCount + (long)pageRowCountLimit;
        for (ColumnWriterBase writer : this.columns.values()) {
            long rowsToFillPage;
            long usedMem = writer.getCurrentPageBufferedSize();
            long rows = this.rowCount - writer.getRowsWrittenSoFar();
            long remainingMem = (long)this.props.getPageSizeThreshold() - usedMem;
            if (remainingMem <= this.thresholdTolerance || rows >= (long)pageRowCountLimit) {
                writer.writePage();
                remainingMem = this.props.getPageSizeThreshold();
            } else {
                rowCountForNextRowCountCheck = Math.min(rowCountForNextRowCountCheck, writer.getRowsWrittenSoFar() + (long)pageRowCountLimit);
            }
            if ((rowsToFillPage = usedMem == 0L ? (long)this.props.getMaxRowCountForPageSizeCheck() : rows / usedMem * remainingMem) >= minRecordToWait) continue;
            minRecordToWait = rowsToFillPage;
        }
        if (minRecordToWait == Long.MAX_VALUE) {
            minRecordToWait = this.props.getMinRowCountForPageSizeCheck();
        }
        this.rowCountForNextSizeCheck = this.props.estimateNextSizeCheck() ? this.rowCount + Math.min(Math.max(minRecordToWait / 2L, (long)this.props.getMinRowCountForPageSizeCheck()), (long)this.props.getMaxRowCountForPageSizeCheck()) : this.rowCount + (long)this.props.getMinRowCountForPageSizeCheck();
        if (rowCountForNextRowCountCheck < this.rowCountForNextSizeCheck) {
            this.rowCountForNextSizeCheck = rowCountForNextRowCountCheck;
        }
    }

    @Override
    public boolean isColumnFlushNeeded() {
        return this.rowCount + 1L >= this.rowCountForNextSizeCheck;
    }

    private static interface ColumnWriterProvider {
        public ColumnWriter getColumnWriter(ColumnDescriptor var1);
    }
}

