/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class SnapshotUtil {
    private SnapshotUtil() {
    }

    public static boolean ancestorOf(Table table, long snapshotId, long ancestorSnapshotId) {
        Snapshot current = table.snapshot(snapshotId);
        while (current != null) {
            long id = current.snapshotId();
            if (ancestorSnapshotId == id) {
                return true;
            }
            if (current.parentId() != null) {
                current = table.snapshot(current.parentId());
                continue;
            }
            return false;
        }
        return false;
    }

    public static List<Long> currentAncestors(Table table) {
        return SnapshotUtil.ancestorIds(table.currentSnapshot(), table::snapshot);
    }

    public static Snapshot oldestSnapshot(Table table) {
        Snapshot current = table.currentSnapshot();
        while (current != null && current.parentId() != null) {
            current = table.snapshot(current.parentId());
        }
        return current;
    }

    public static List<Long> snapshotIdsBetween(Table table, long fromSnapshotId, long toSnapshotId) {
        ArrayList<Long> snapshotIds = Lists.newArrayList(SnapshotUtil.ancestorIds(table.snapshot(toSnapshotId), snapshotId -> snapshotId != fromSnapshotId ? table.snapshot((long)snapshotId) : null));
        return snapshotIds;
    }

    public static List<Long> ancestorIds(Snapshot snapshot, Function<Long, Snapshot> lookup) {
        ArrayList<Long> ancestorIds = Lists.newArrayList();
        Snapshot current = snapshot;
        while (current != null) {
            ancestorIds.add(current.snapshotId());
            if (current.parentId() != null) {
                current = lookup.apply(current.parentId());
                continue;
            }
            current = null;
        }
        return ancestorIds;
    }

    public static List<DataFile> newFiles(Long baseSnapshotId, long latestSnapshotId, Function<Long, Snapshot> lookup) {
        ArrayList<DataFile> newFiles = Lists.newArrayList();
        Long currentSnapshotId = latestSnapshotId;
        while (currentSnapshotId != null && !currentSnapshotId.equals(baseSnapshotId)) {
            Snapshot currentSnapshot = lookup.apply(currentSnapshotId);
            if (currentSnapshot == null) {
                throw new ValidationException("Cannot determine history between read snapshot %s and current %s", baseSnapshotId, currentSnapshotId);
            }
            Iterables.addAll(newFiles, currentSnapshot.addedFiles());
            currentSnapshotId = currentSnapshot.parentId();
        }
        return newFiles;
    }

    public static Snapshot snapshotAfter(Table table, long snapshotId) {
        Preconditions.checkArgument(table.snapshot(snapshotId) != null, "Cannot find parent snapshot: %s", snapshotId);
        Snapshot current = table.currentSnapshot();
        while (current != null) {
            if (current.parentId() == snapshotId) {
                return current;
            }
            current = table.snapshot(current.parentId());
        }
        throw new IllegalStateException(String.format("Cannot find snapshot after %s: not an ancestor of table's current snapshot", snapshotId));
    }
}

