/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.Namespace;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentsKey", generator="Immutables")
@Immutable
public final class ImmutableContentsKey
extends ContentsKey {
    private final List<String> elements;
    private final transient Namespace namespace;
    private final transient int hashCode;

    private ImmutableContentsKey(List<String> elements) {
        this.elements = elements;
        this.namespace = Objects.requireNonNull(super.getNamespace(), "namespace");
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="elements")
    public List<String> getElements() {
        return this.elements;
    }

    @Override
    @JsonProperty(value="namespace")
    @JsonIgnore
    public Namespace getNamespace() {
        return this.namespace;
    }

    public final ImmutableContentsKey withElements(String ... elements) {
        List<String> newValue = ImmutableContentsKey.createUnmodifiableList(false, ImmutableContentsKey.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableContentsKey.validate(new ImmutableContentsKey(newValue));
    }

    public final ImmutableContentsKey withElements(Iterable<String> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<String> newValue = ImmutableContentsKey.createUnmodifiableList(false, ImmutableContentsKey.createSafeList(elements, true, false));
        return ImmutableContentsKey.validate(new ImmutableContentsKey(newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentsKey && this.equalTo((ImmutableContentsKey)another);
    }

    private boolean equalTo(ImmutableContentsKey another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.elements.equals(another.elements) && this.namespace.equals(another.namespace);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.elements.hashCode();
        h2 += (h2 << 5) + this.namespace.hashCode();
        return h2;
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentsKey fromJson(Json json) {
        Builder builder = ImmutableContentsKey.builder();
        if (json.elements != null) {
            builder.addAllElements(json.elements);
        }
        return builder.build();
    }

    private static ImmutableContentsKey validate(ImmutableContentsKey instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableContentsKey copyOf(ContentsKey instance) {
        if (instance instanceof ImmutableContentsKey) {
            return (ImmutableContentsKey)instance;
        }
        return ImmutableContentsKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ContentsKey", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<String> elements = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentsKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllElements(instance.getElements());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(String element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(String ... elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        @JsonProperty(value="elements")
        @CanIgnoreReturnValue
        public final Builder elements(Iterable<String> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllElements(Iterable<String> elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public ImmutableContentsKey build() {
            return ImmutableContentsKey.validate(new ImmutableContentsKey(ImmutableContentsKey.createUnmodifiableList(true, this.elements)));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContentsKey", generator="Immutables")
    static final class Json
    extends ContentsKey {
        @Nullable
        List<String> elements = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="elements")
        public void setElements(List<String> elements) {
            this.elements = elements;
        }

        @Override
        public List<String> getElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Namespace getNamespace() {
            throw new UnsupportedOperationException();
        }
    }
}

