/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.PaginatedResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EntriesResponse", generator="Immutables")
@Immutable
public final class ImmutableEntriesResponse
implements EntriesResponse {
    private final boolean hasMore;
    @Nullable
    private final String token;
    private final List<EntriesResponse.Entry> entries;
    private final transient int hashCode;

    private ImmutableEntriesResponse(Builder builder) {
        this.token = builder.token;
        this.entries = ImmutableEntriesResponse.createUnmodifiableList(true, builder.entries);
        this.hasMore = builder.hasMoreIsSet() ? builder.hasMore : EntriesResponse.super.hasMore();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableEntriesResponse(boolean hasMore, @Nullable String token, List<EntriesResponse.Entry> entries) {
        this.hasMore = hasMore;
        this.token = token;
        this.entries = entries;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="hasMore")
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    @JsonProperty(value="token")
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="entries")
    public List<EntriesResponse.Entry> getEntries() {
        return this.entries;
    }

    public final ImmutableEntriesResponse withHasMore(boolean value) {
        if (this.hasMore == value) {
            return this;
        }
        return new ImmutableEntriesResponse(value, this.token, this.entries);
    }

    public final ImmutableEntriesResponse withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableEntriesResponse(this.hasMore, value, this.entries);
    }

    public final ImmutableEntriesResponse withEntries(EntriesResponse.Entry ... elements) {
        List<EntriesResponse.Entry> newValue = ImmutableEntriesResponse.createUnmodifiableList(false, ImmutableEntriesResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEntriesResponse(this.hasMore, this.token, newValue);
    }

    public final ImmutableEntriesResponse withEntries(Iterable<? extends EntriesResponse.Entry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<EntriesResponse.Entry> newValue = ImmutableEntriesResponse.createUnmodifiableList(false, ImmutableEntriesResponse.createSafeList(elements, true, false));
        return new ImmutableEntriesResponse(this.hasMore, this.token, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntriesResponse && this.equalTo((ImmutableEntriesResponse)another);
    }

    private boolean equalTo(ImmutableEntriesResponse another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.hasMore == another.hasMore && Objects.equals(this.token, another.token) && this.entries.equals(another.entries);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Boolean.hashCode(this.hasMore);
        h2 += (h2 << 5) + Objects.hashCode(this.token);
        h2 += (h2 << 5) + this.entries.hashCode();
        return h2;
    }

    public String toString() {
        return "EntriesResponse{hasMore=" + this.hasMore + ", token=" + this.token + ", entries=" + this.entries + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntriesResponse fromJson(Json json) {
        Builder builder = ImmutableEntriesResponse.builder();
        if (json.hasMoreIsSet) {
            builder.hasMore(json.hasMore);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.entries != null) {
            builder.addAllEntries(json.entries);
        }
        return builder.build();
    }

    public static ImmutableEntriesResponse copyOf(EntriesResponse instance) {
        if (instance instanceof ImmutableEntriesResponse) {
            return (ImmutableEntriesResponse)instance;
        }
        return ImmutableEntriesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="EntriesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_HAS_MORE = 1L;
        private long optBits;
        private boolean hasMore;
        @Nullable
        private String token;
        private List<EntriesResponse.Entry> entries = new ArrayList<EntriesResponse.Entry>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PaginatedResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(EntriesResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedResponse instance;
            if (object instanceof PaginatedResponse) {
                instance = (PaginatedResponse)object;
                this.hasMore(instance.hasMore());
                String tokenValue = instance.getToken();
                if (tokenValue != null) {
                    this.token(tokenValue);
                }
            }
            if (object instanceof EntriesResponse) {
                instance = (EntriesResponse)object;
                this.addAllEntries(instance.getEntries());
            }
        }

        @JsonProperty(value="hasMore")
        @CanIgnoreReturnValue
        public final Builder hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="token")
        @CanIgnoreReturnValue
        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(EntriesResponse.Entry element) {
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntries(EntriesResponse.Entry ... elements) {
            for (EntriesResponse.Entry element : elements) {
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return this;
        }

        @JsonProperty(value="entries")
        @CanIgnoreReturnValue
        public final Builder entries(Iterable<? extends EntriesResponse.Entry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntries(Iterable<? extends EntriesResponse.Entry> elements) {
            for (EntriesResponse.Entry entry : elements) {
                this.entries.add(Objects.requireNonNull(entry, "entries element"));
            }
            return this;
        }

        public ImmutableEntriesResponse build() {
            return new ImmutableEntriesResponse(this);
        }

        private boolean hasMoreIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntriesResponse", generator="Immutables")
    static final class Json
    implements EntriesResponse {
        boolean hasMore;
        boolean hasMoreIsSet;
        @Nullable
        String token;
        @Nullable
        List<EntriesResponse.Entry> entries = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="hasMore")
        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
            this.hasMoreIsSet = true;
        }

        @JsonProperty(value="token")
        public void setToken(@Nullable String token) {
            this.token = token;
        }

        @JsonProperty(value="entries")
        public void setEntries(List<EntriesResponse.Entry> entries) {
            this.entries = entries;
        }

        @Override
        public boolean hasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EntriesResponse.Entry> getEntries() {
            throw new UnsupportedOperationException();
        }
    }
}

