/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.glue;

import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ValidationException;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.Table;

class GlueToIcebergConverter {
    private GlueToIcebergConverter() {
    }

    static Namespace toNamespace(Database database) {
        return Namespace.of(database.name());
    }

    static TableIdentifier toTableId(Table table) {
        return TableIdentifier.of(table.databaseName(), table.name());
    }

    static void validateTable(Table table, String fullName) {
        String tableType = (String)table.parameters().get("table_type");
        ValidationException.check(tableType != null && tableType.equalsIgnoreCase("iceberg"), "Input Glue table is not an iceberg table: %s (type=%s)", fullName, tableType);
    }
}

