/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache;

import com.google.api.client.http.LowLevelHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.iceberg.gcp.shaded.org.apache.http.Header;
import org.apache.iceberg.gcp.shaded.org.apache.http.HttpEntity;
import org.apache.iceberg.gcp.shaded.org.apache.http.HttpResponse;
import org.apache.iceberg.gcp.shaded.org.apache.http.StatusLine;
import org.apache.iceberg.gcp.shaded.org.apache.http.client.methods.HttpRequestBase;

final class ApacheHttpResponse
extends LowLevelHttpResponse {
    private final HttpRequestBase request;
    private final HttpResponse response;
    private final Header[] allHeaders;

    ApacheHttpResponse(HttpRequestBase request, HttpResponse response) {
        this.request = request;
        this.response = response;
        this.allHeaders = response.getAllHeaders();
    }

    @Override
    public int getStatusCode() {
        StatusLine statusLine = this.response.getStatusLine();
        return statusLine == null ? 0 : statusLine.getStatusCode();
    }

    @Override
    public InputStream getContent() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity == null ? null : entity.getContent();
    }

    @Override
    public String getContentEncoding() {
        Header contentEncodingHeader;
        HttpEntity entity = this.response.getEntity();
        if (entity != null && (contentEncodingHeader = entity.getContentEncoding()) != null) {
            return contentEncodingHeader.getValue();
        }
        return null;
    }

    @Override
    public long getContentLength() {
        HttpEntity entity = this.response.getEntity();
        return entity == null ? -1L : entity.getContentLength();
    }

    @Override
    public String getContentType() {
        Header contentTypeHeader;
        HttpEntity entity = this.response.getEntity();
        if (entity != null && (contentTypeHeader = entity.getContentType()) != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    @Override
    public String getReasonPhrase() {
        StatusLine statusLine = this.response.getStatusLine();
        return statusLine == null ? null : statusLine.getReasonPhrase();
    }

    @Override
    public String getStatusLine() {
        StatusLine statusLine = this.response.getStatusLine();
        return statusLine == null ? null : statusLine.toString();
    }

    public String getHeaderValue(String name) {
        return this.response.getLastHeader(name).getValue();
    }

    @Override
    public int getHeaderCount() {
        return this.allHeaders.length;
    }

    @Override
    public String getHeaderName(int index) {
        return this.allHeaders[index].getName();
    }

    @Override
    public String getHeaderValue(int index) {
        return this.allHeaders[index].getValue();
    }

    @Override
    public void disconnect() {
        this.request.abort();
    }
}

