/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.http;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpResponseException;
import com.google.api.core.InternalApi;
import com.google.cloud.BaseServiceException;
import java.io.IOException;
import java.util.Set;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;

public class BaseHttpServiceException
extends BaseServiceException {
    private static final long serialVersionUID = -5793034110344127954L;
    public static final int UNKNOWN_CODE = 0;

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected BaseHttpServiceException(IOException exception, boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
        super(BaseHttpServiceException.makeExceptionData(exception, idempotent, retryableErrors));
    }

    private static BaseServiceException.ExceptionData makeExceptionData(IOException exception, boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
        int code = 0;
        String reason = null;
        String location = null;
        String debugInfo = null;
        Boolean retryable = null;
        if (exception instanceof HttpResponseException) {
            if (exception instanceof GoogleJsonResponseException) {
                GoogleJsonError jsonError = ((GoogleJsonResponseException)exception).getDetails();
                if (jsonError != null) {
                    BaseServiceException.Error error = new BaseServiceException.Error(jsonError.getCode(), BaseHttpServiceException.reason(jsonError));
                    code = error.getCode();
                    reason = error.getReason();
                    retryable = error.isRetryable(idempotent, retryableErrors);
                    if (reason != null) {
                        GoogleJsonError.ErrorInfo errorInfo = jsonError.getErrors().get(0);
                        location = errorInfo.getLocation();
                        debugInfo = (String)errorInfo.get("debugInfo");
                    }
                } else {
                    code = ((GoogleJsonResponseException)exception).getStatusCode();
                    retryable = BaseServiceException.isRetryable(code, null, idempotent, retryableErrors);
                }
            } else {
                code = ((HttpResponseException)exception).getStatusCode();
                retryable = BaseServiceException.isRetryable(code, null, idempotent, retryableErrors);
            }
        }
        return BaseServiceException.ExceptionData.newBuilder().setMessage(BaseHttpServiceException.message(exception)).setCause(exception).setRetryable(MoreObjects.firstNonNull(retryable, BaseServiceException.isRetryable(idempotent, exception))).setCode(code).setReason(reason).setLocation(location).setDebugInfo(debugInfo).build();
    }

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected BaseHttpServiceException(GoogleJsonError googleJsonError, boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
        super(BaseHttpServiceException.makeExceptionData(googleJsonError, idempotent, retryableErrors));
    }

    private static BaseServiceException.ExceptionData makeExceptionData(GoogleJsonError googleJsonError, boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
        int code = googleJsonError.getCode();
        String reason = BaseHttpServiceException.reason(googleJsonError);
        BaseServiceException.ExceptionData.Builder exceptionData = BaseServiceException.ExceptionData.newBuilder();
        exceptionData.setMessage(googleJsonError.getMessage()).setCause(null).setRetryable(BaseServiceException.isRetryable(code, reason, idempotent, retryableErrors)).setCode(code).setReason(reason);
        if (reason != null) {
            GoogleJsonError.ErrorInfo errorInfo = googleJsonError.getErrors().get(0);
            exceptionData.setLocation(errorInfo.getLocation());
            exceptionData.setDebugInfo((String)errorInfo.get("debugInfo"));
        } else {
            exceptionData.setLocation(null);
            exceptionData.setDebugInfo(null);
        }
        return exceptionData.build();
    }

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected BaseHttpServiceException(int code, String message, String reason, boolean idempotent, Set<BaseServiceException.Error> retryableErrors) {
        this(code, message, reason, idempotent, retryableErrors, null);
    }

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected BaseHttpServiceException(int code, String message, String reason, boolean idempotent, Set<BaseServiceException.Error> retryableErrors, Throwable cause) {
        super(BaseServiceException.ExceptionData.newBuilder().setMessage(message).setCause(cause).setRetryable(BaseServiceException.isRetryable(code, reason, idempotent, retryableErrors)).setCode(code).setReason(reason).setLocation(null).setDebugInfo(null).build());
    }

    private static String reason(GoogleJsonError error) {
        if (error.getErrors() != null && !error.getErrors().isEmpty()) {
            return error.getErrors().get(0).getReason();
        }
        return null;
    }

    private static String message(IOException exception) {
        GoogleJsonError details;
        if (exception instanceof GoogleJsonResponseException && (details = ((GoogleJsonResponseException)exception).getDetails()) != null) {
            return details.getMessage();
        }
        return exception.getMessage();
    }
}

