/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.RestoreObjectRequest;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import java.io.Serializable;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.ByteString;

final class GrpcRetryAlgorithmManager
implements Serializable {
    private static final long serialVersionUID = 3084833873820431477L;
    final StorageRetryStrategy retryStrategy;

    GrpcRetryAlgorithmManager(StorageRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    ResultRetryAlgorithm<?> idempotent() {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ComposeObjectRequest req) {
        return req.hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(CreateBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(DeleteObjectRequest req) {
        if (req.getGeneration() > 0L || req.hasIfGenerationMatch()) {
            return this.retryStrategy.getIdempotentHandler();
        }
        return this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetBucketRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetIamPolicyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(GetObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(RestoreObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListBucketsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ListObjectsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(LockBucketRetentionPolicyRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(QueryWriteStatusRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(ReadObjectRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(RewriteObjectRequest req) {
        return req.hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(SetIamPolicyRequest req) {
        if (req.getPolicy().getEtag().equals(ByteString.empty())) {
            return this.retryStrategy.getNonidempotentHandler();
        }
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(StartResumableWriteRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(TestIamPermissionsRequest req) {
        return this.retryStrategy.getIdempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateBucketRequest req) {
        return req.hasIfMetagenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(UpdateObjectRequest req) {
        return req.hasIfMetagenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(WriteObjectRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public ResultRetryAlgorithm<?> getFor(BidiWriteObjectRequest req) {
        return req.getWriteObjectSpec().hasIfGenerationMatch() ? this.retryStrategy.getIdempotentHandler() : this.retryStrategy.getNonidempotentHandler();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GrpcRetryAlgorithmManager)) {
            return false;
        }
        GrpcRetryAlgorithmManager that = (GrpcRetryAlgorithmManager)o;
        return Objects.equals(this.retryStrategy, that.retryStrategy);
    }

    public int hashCode() {
        return Objects.hashCode(this.retryStrategy);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("retryStrategy", this.retryStrategy).toString();
    }
}

