/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.spi.v1.StorageRpc;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.gson.Gson;
import org.apache.iceberg.gcp.shaded.com.google.gson.stream.JsonReader;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

final class JsonResumableWrite
implements Serializable {
    private static final long serialVersionUID = 7934407897802252292L;
    private static final Gson gson = new Gson();
    private transient @MonotonicNonNull StorageObject object;
    private final @MonotonicNonNull Map<StorageRpc.Option, ?> options;
    private final @MonotonicNonNull String signedUrl;
    private final @NonNull String uploadId;
    private final long beginOffset;
    private volatile String objectJson;

    private JsonResumableWrite(StorageObject object, Map<StorageRpc.Option, ?> options, String signedUrl, @NonNull String uploadId, long beginOffset) {
        this.object = object;
        this.options = options;
        this.signedUrl = signedUrl;
        this.uploadId = uploadId;
        this.beginOffset = beginOffset;
    }

    public @NonNull String getUploadId() {
        return this.uploadId;
    }

    public long getBeginOffset() {
        return this.beginOffset;
    }

    public JsonResumableWrite withBeginOffset(long newBeginOffset) {
        Preconditions.checkArgument(newBeginOffset >= this.beginOffset, "New beginOffset must be >= existing beginOffset (%s >= %s)", newBeginOffset, this.beginOffset);
        return new JsonResumableWrite(this.object, this.options, this.signedUrl, this.uploadId, newBeginOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonResumableWrite)) {
            return false;
        }
        JsonResumableWrite that = (JsonResumableWrite)o;
        return this.beginOffset == that.beginOffset && Objects.equals(this.object, that.object) && Objects.equals(this.options, that.options) && Objects.equals(this.signedUrl, that.signedUrl) && Objects.equals(this.uploadId, that.uploadId);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.options, this.signedUrl, this.uploadId, this.beginOffset);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("object", this.object).add("options", this.options).add("signedUrl", this.signedUrl).add("uploadId", this.uploadId).add("beginOffset", this.beginOffset).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getObjectJson() {
        if (this.objectJson == null) {
            JsonResumableWrite jsonResumableWrite = this;
            synchronized (jsonResumableWrite) {
                if (this.objectJson == null) {
                    this.objectJson = gson.toJson(this.object);
                }
            }
        }
        return this.objectJson;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String ignore = this.getObjectJson();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        JsonReader jsonReader = gson.newJsonReader(new StringReader(this.objectJson));
        this.object = (StorageObject)gson.fromJson(jsonReader, (Type)((Object)StorageObject.class));
    }

    static JsonResumableWrite of(StorageObject req, Map<StorageRpc.Option, ?> options, String uploadId, long beginOffset) {
        return new JsonResumableWrite(req, options, null, uploadId, beginOffset);
    }

    static JsonResumableWrite of(String signedUrl, String uploadId, long beginOffset) {
        return new JsonResumableWrite(null, null, signedUrl, uploadId, beginOffset);
    }
}

