/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

public class GCPProperties
implements Serializable {
    public static final String GCS_PROJECT_ID = "gcs.project-id";
    public static final String GCS_CLIENT_LIB_TOKEN = "gcs.client-lib-token";
    public static final String GCS_SERVICE_HOST = "gcs.service.host";
    public static final String GCS_DECRYPTION_KEY = "gcs.decryption-key";
    public static final String GCS_ENCRYPTION_KEY = "gcs.encryption-key";
    public static final String GCS_USER_PROJECT = "gcs.user-project";
    public static final String GCS_CHANNEL_READ_CHUNK_SIZE = "gcs.channel.read.chunk-size-bytes";
    public static final String GCS_CHANNEL_WRITE_CHUNK_SIZE = "gcs.channel.write.chunk-size-bytes";
    private String projectId;
    private String clientLibToken;
    private String serviceHost;
    private String gcsDecryptionKey;
    private String gcsEncryptionKey;
    private String gcsUserProject;
    private Integer gcsChannelReadChunkSize;
    private Integer gcsChannelWriteChunkSize;

    public GCPProperties() {
    }

    public GCPProperties(Map<String, String> properties) {
        this.projectId = properties.get(GCS_PROJECT_ID);
        this.clientLibToken = properties.get(GCS_CLIENT_LIB_TOKEN);
        this.serviceHost = properties.get(GCS_SERVICE_HOST);
        this.gcsDecryptionKey = properties.get(GCS_DECRYPTION_KEY);
        this.gcsEncryptionKey = properties.get(GCS_ENCRYPTION_KEY);
        this.gcsUserProject = properties.get(GCS_USER_PROJECT);
        if (properties.containsKey(GCS_CHANNEL_READ_CHUNK_SIZE)) {
            this.gcsChannelReadChunkSize = Integer.parseInt(properties.get(GCS_CHANNEL_READ_CHUNK_SIZE));
        }
        if (properties.containsKey(GCS_CHANNEL_WRITE_CHUNK_SIZE)) {
            this.gcsChannelWriteChunkSize = Integer.parseInt(properties.get(GCS_CHANNEL_WRITE_CHUNK_SIZE));
        }
    }

    public Optional<Integer> channelReadChunkSize() {
        return Optional.ofNullable(this.gcsChannelReadChunkSize);
    }

    public Optional<Integer> channelWriteChunkSize() {
        return Optional.ofNullable(this.gcsChannelWriteChunkSize);
    }

    public Optional<String> clientLibToken() {
        return Optional.ofNullable(this.clientLibToken);
    }

    public Optional<String> decryptionKey() {
        return Optional.ofNullable(this.gcsDecryptionKey);
    }

    public Optional<String> encryptionKey() {
        return Optional.ofNullable(this.gcsEncryptionKey);
    }

    public Optional<String> projectId() {
        return Optional.ofNullable(this.projectId);
    }

    public Optional<String> serviceHost() {
        return Optional.ofNullable(this.serviceHost);
    }

    public Optional<String> userProject() {
        return Optional.ofNullable(this.gcsUserProject);
    }
}

