/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.GCSInputFile;
import org.apache.iceberg.gcp.gcs.GCSOutputFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSFileIO
implements FileIO {
    private static final Logger LOG = LoggerFactory.getLogger(GCSFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "org.apache.iceberg.hadoop.HadoopMetricsContext";
    private SerializableSupplier<Storage> storageSupplier;
    private GCPProperties gcpProperties;
    private volatile transient Storage storage;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private final AtomicBoolean isResourceClosed = new AtomicBoolean(false);
    private SerializableMap<String, String> properties = null;

    public GCSFileIO() {
    }

    public GCSFileIO(SerializableSupplier<Storage> storageSupplier, GCPProperties gcpProperties) {
        this.storageSupplier = storageSupplier;
        this.gcpProperties = gcpProperties;
    }

    public InputFile newInputFile(String path) {
        return GCSInputFile.fromLocation(path, this.client(), this.gcpProperties, this.metrics);
    }

    public InputFile newInputFile(String path, long length) {
        return GCSInputFile.fromLocation(path, length, this.client(), this.gcpProperties, this.metrics);
    }

    public OutputFile newOutputFile(String path) {
        return GCSOutputFile.fromLocation(path, this.client(), this.gcpProperties, this.metrics);
    }

    public void deleteFile(String path) {
        if (!this.client().delete(BlobId.fromGsUtilUri((String)path))) {
            LOG.warn("Failed to delete path: {}", (Object)path);
        }
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage client() {
        if (this.storage == null) {
            GCSFileIO gCSFileIO = this;
            synchronized (gCSFileIO) {
                if (this.storage == null) {
                    this.storage = (Storage)this.storageSupplier.get();
                }
            }
        }
        return this.storage;
    }

    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.gcpProperties = new GCPProperties((Map<String, String>)this.properties);
        this.storageSupplier = (SerializableSupplier & Serializable)() -> {
            StorageOptions.Builder builder = StorageOptions.newBuilder();
            this.gcpProperties.projectId().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setProjectId(arg_0));
            this.gcpProperties.clientLibToken().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setClientLibToken(arg_0));
            this.gcpProperties.serviceHost().ifPresent(arg_0 -> ((StorageOptions.Builder)builder).setHost(arg_0));
            try {
                DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, new Class[]{String.class}).buildChecked();
                MetricsContext context = (MetricsContext)ctor.newInstance(new Object[]{"gcs"});
                context.initialize(this.properties);
                this.metrics = context;
            }
            catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
                LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL, (Object)e);
            }
            return (Storage)builder.build().getService();
        };
    }

    public void close() {
        if (this.isResourceClosed.compareAndSet(false, true) && this.storage != null) {
            this.storage = null;
        }
    }
}

