/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.BaseGCSFile;
import org.apache.iceberg.gcp.gcs.GCSInputStream;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.MetricsContext;

class GCSInputFile
extends BaseGCSFile
implements InputFile {
    private Long length;

    static GCSInputFile fromLocation(String location, Storage storage, GCPProperties gcpProperties, MetricsContext metrics) {
        return new GCSInputFile(storage, BlobId.fromGsUtilUri((String)location), null, gcpProperties, metrics);
    }

    static GCSInputFile fromLocation(String location, long length, Storage storage, GCPProperties gcpProperties, MetricsContext metrics) {
        return new GCSInputFile(storage, BlobId.fromGsUtilUri((String)location), length > 0L ? Long.valueOf(length) : null, gcpProperties, metrics);
    }

    GCSInputFile(Storage storage, BlobId blobId, Long length, GCPProperties gcpProperties, MetricsContext metrics) {
        super(storage, blobId, gcpProperties, metrics);
        this.length = length;
    }

    public long getLength() {
        if (this.length == null) {
            this.length = this.getBlob().getSize();
        }
        return this.length;
    }

    public SeekableInputStream newStream() {
        return new GCSInputStream(this.storage(), this.blobId(), this.gcpProperties(), this.metrics());
    }
}

