/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.api.client.util.Lists;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.io.RangeReadable;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GCSInputStream
extends SeekableInputStream
implements RangeReadable {
    private static final Logger LOG = LoggerFactory.getLogger(GCSInputStream.class);
    private final StackTraceElement[] createStack;
    private final Storage storage;
    private final BlobId blobId;
    private Long blobSize;
    private final GCPProperties gcpProperties;
    private ReadChannel channel;
    private long pos = 0L;
    private boolean closed = false;
    private final ByteBuffer singleByteBuffer = ByteBuffer.wrap(new byte[1]);
    private ByteBuffer byteBuffer;
    private final Counter readBytes;
    private final Counter readOperations;

    GCSInputStream(Storage storage, BlobId blobId, Long blobSize, GCPProperties gcpProperties, MetricsContext metrics) {
        this.storage = storage;
        this.blobId = blobId;
        this.blobSize = blobSize;
        this.gcpProperties = gcpProperties;
        this.readBytes = metrics.counter("read.bytes", MetricsContext.Unit.BYTES);
        this.readOperations = metrics.counter("read.operations");
        this.createStack = Thread.currentThread().getStackTrace();
        this.openStream();
    }

    private void openStream() {
        this.channel = this.openChannel();
    }

    private ReadChannel openChannel() {
        ArrayList sourceOptions = Lists.newArrayList();
        this.gcpProperties.decryptionKey().ifPresent(key -> sourceOptions.add(Storage.BlobSourceOption.decryptionKey((String)key)));
        this.gcpProperties.userProject().ifPresent(userProject -> sourceOptions.add(Storage.BlobSourceOption.userProject((String)userProject)));
        ReadChannel result = this.storage.reader(this.blobId, sourceOptions.toArray(new Storage.BlobSourceOption[0]));
        this.gcpProperties.channelReadChunkSize().ifPresent(arg_0 -> ((ReadChannel)result).setChunkSize(arg_0));
        return result;
    }

    public long getPos() {
        return this.pos;
    }

    public void seek(long newPos) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"already closed");
        Preconditions.checkArgument((newPos >= 0L ? 1 : 0) != 0, (String)"position is negative: %s", (long)newPos);
        this.pos = newPos;
        try {
            this.channel.seek(newPos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int read() throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot read: already closed");
        this.singleByteBuffer.position(0);
        ++this.pos;
        this.channel.read(this.singleByteBuffer);
        this.readBytes.increment();
        this.readOperations.increment();
        return this.singleByteBuffer.array()[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cannot read: already closed");
        this.byteBuffer = this.byteBuffer != null && this.byteBuffer.array() == b ? this.byteBuffer : ByteBuffer.wrap(b);
        int bytesRead = this.read(this.channel, this.byteBuffer, off, len);
        this.pos += (long)bytesRead;
        this.readBytes.increment(bytesRead);
        this.readOperations.increment();
        return bytesRead;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        try (ReadChannel readChannel = this.openChannel();){
            readChannel.seek(position);
            readChannel.limit(position + (long)length);
            int bytesRead = this.read(readChannel, ByteBuffer.wrap(buffer), offset, length);
            if (bytesRead < length) {
                throw new EOFException("Reached the end of stream with " + (length - bytesRead) + " bytes left to read");
            }
        }
    }

    public int readTail(byte[] buffer, int offset, int length) throws IOException {
        if (this.blobSize == null) {
            this.blobSize = this.storage.get(this.blobId).getSize();
        }
        long startPosition = Math.max(0L, this.blobSize - (long)length);
        try (ReadChannel readChannel = this.openChannel();){
            readChannel.seek(startPosition);
            int n = this.read(readChannel, ByteBuffer.wrap(buffer), offset, length);
            return n;
        }
    }

    private int read(ReadChannel readChannel, ByteBuffer buffer, int off, int len) throws IOException {
        buffer.position(off);
        buffer.limit(Math.min(off + len, buffer.capacity()));
        return readChannel.read(buffer);
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.channel != null) {
            this.channel.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
        }
    }
}

