/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class TestHiveCatalog
extends HiveMetastoreTest {
    private static ImmutableMap meta = ImmutableMap.of((Object)"owner", (Object)"apache", (Object)"group", (Object)"iceberg", (Object)"comment", (Object)"iceberg  hiveCatalog test");
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableBuilder() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.newFolder("tbl").toString();
        try {
            Table table = catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withLocation(location).withProperty("key1", "value1").withProperty("key2", "value2").create();
            Assert.assertEquals((Object)location, (Object)table.location());
            Assert.assertEquals((long)2L, (long)table.schema().columns().size());
            Assert.assertEquals((long)1L, (long)table.spec().fields().size());
            Assert.assertEquals((Object)"value1", table.properties().get("key1"));
            Assert.assertEquals((Object)"value2", table.properties().get("key2"));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableWithCaching() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.newFolder("tbl").toString();
        ImmutableMap properties = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        Catalog cachingCatalog = CachingCatalog.wrap((Catalog)catalog);
        try {
            Table table = cachingCatalog.createTable(tableIdent, schema, spec, location, (Map)properties);
            Assert.assertEquals((Object)location, (Object)table.location());
            Assert.assertEquals((long)2L, (long)table.schema().columns().size());
            Assert.assertEquals((long)1L, (long)table.spec().fields().size());
            Assert.assertEquals((Object)"value1", table.properties().get("key1"));
            Assert.assertEquals((Object)"value2", table.properties().get("key2"));
        }
        finally {
            cachingCatalog.dropTable(tableIdent);
        }
    }

    @Test
    public void testInitialize() {
        Assertions.assertDoesNotThrow(() -> {
            HiveCatalog catalog = new HiveCatalog();
            catalog.initialize("hive", (Map)Maps.newHashMap());
        });
    }

    @Test
    public void testToStringWithoutSetConf() {
        Assertions.assertDoesNotThrow(() -> {
            HiveCatalog catalog = new HiveCatalog();
            catalog.toString();
        });
    }

    @Test
    public void testInitializeCatalogWithProperties() {
        HashMap properties = Maps.newHashMap();
        properties.put("uri", "thrift://examplehost:9083");
        properties.put("warehouse", "/user/hive/testwarehouse");
        HiveCatalog catalog = new HiveCatalog();
        catalog.initialize("hive", (Map)properties);
        Assert.assertEquals((Object)catalog.getConf().get("hive.metastore.uris"), (Object)"thrift://examplehost:9083");
        Assert.assertEquals((Object)catalog.getConf().get("hive.metastore.warehouse.dir"), (Object)"/user/hive/testwarehouse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableTxnBuilder() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.newFolder("tbl").toString();
        try {
            Transaction txn = catalog.buildTable(tableIdent, schema).withLocation(location).createTransaction();
            txn.commitTransaction();
            Table table = catalog.loadTable(tableIdent);
            Assert.assertEquals((Object)location, (Object)table.location());
            Assert.assertEquals((long)2L, (long)table.schema().columns().size());
            Assert.assertTrue((boolean)table.spec().isUnpartitioned());
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceTxnBuilder() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.newFolder("tbl").toString();
        try {
            Transaction createTxn = catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withLocation(location).withProperty("key1", "value1").createOrReplaceTransaction();
            createTxn.commitTransaction();
            Table table = catalog.loadTable(tableIdent);
            Assert.assertEquals((long)1L, (long)table.spec().fields().size());
            String newLocation = this.temp.newFolder("tbl-2").toString();
            Transaction replaceTxn = catalog.buildTable(tableIdent, schema).withProperty("key2", "value2").withLocation(newLocation).replaceTransaction();
            replaceTxn.commitTransaction();
            table = catalog.loadTable(tableIdent);
            Assert.assertEquals((Object)newLocation, (Object)table.location());
            Assert.assertNull((Object)table.currentSnapshot());
            PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("data", "data_bucket").withSpecId(1).build();
            Assert.assertEquals((String)"Table should have a spec with one void field", (Object)v1Expected, (Object)table.spec());
            Assert.assertEquals((Object)"value1", table.properties().get("key1"));
            Assert.assertEquals((Object)"value2", table.properties().get("key2"));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableDefaultSortOrder() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.createTable(tableIdent, schema, spec);
            Assert.assertEquals((String)"Order ID must match", (long)0L, (long)table.sortOrder().orderId());
            Assert.assertTrue((String)"Order must unsorted", (boolean)table.sortOrder().isUnsorted());
            Assert.assertFalse((String)"Must not have default sort order in catalog", (boolean)this.hmsTableParameters().containsKey("default-sort-order"));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableCustomSortOrder() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        SortOrder order = ((SortOrder.Builder)SortOrder.builderFor((Schema)schema).asc("id", NullOrder.NULLS_FIRST)).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).withSortOrder(order).create();
            SortOrder sortOrder = table.sortOrder();
            Assert.assertEquals((String)"Order ID must match", (long)1L, (long)sortOrder.orderId());
            Assert.assertEquals((String)"Order must have 1 field", (long)1L, (long)sortOrder.fields().size());
            Assert.assertEquals((String)"Direction must match ", (Object)SortDirection.ASC, (Object)((SortField)sortOrder.fields().get(0)).direction());
            Assert.assertEquals((String)"Null order must match ", (Object)NullOrder.NULLS_FIRST, (Object)((SortField)sortOrder.fields().get(0)).nullOrder());
            Transform transform = Transforms.identity((Type)Types.IntegerType.get());
            Assert.assertEquals((String)"Transform must match", (Object)transform, (Object)((SortField)sortOrder.fields().get(0)).transform());
            Assert.assertEquals((Object)SortOrderParser.toJson((SortOrder)table.sortOrder()), (Object)this.hmsTableParameters().get("default-sort-order"));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    @Test
    public void testCreateNamespace() throws Exception {
        Namespace namespace1 = Namespace.of((String[])new String[]{"noLocation"});
        catalog.createNamespace(namespace1, (Map)meta);
        Database database1 = metastoreClient.getDatabase(namespace1.toString());
        Assert.assertTrue((boolean)((String)database1.getParameters().get("owner")).equals("apache"));
        Assert.assertTrue((boolean)((String)database1.getParameters().get("group")).equals("iceberg"));
        Assert.assertEquals((String)"There no same location for db and namespace", (Object)database1.getLocationUri(), (Object)this.defaultUri(namespace1));
        AssertHelpers.assertThrows((String)("Should fail to create when namespace already exist " + namespace1), AlreadyExistsException.class, (String)("Namespace '" + namespace1 + "' already exists!"), () -> catalog.createNamespace(namespace1));
        String hiveLocalDir = this.temp.newFolder().toURI().toString();
        hiveLocalDir = hiveLocalDir.substring(0, hiveLocalDir.length() - 1);
        ImmutableMap newMeta = ImmutableMap.builder().putAll((Map)meta).put((Object)"location", (Object)hiveLocalDir).build();
        Namespace namespace2 = Namespace.of((String[])new String[]{"haveLocation"});
        catalog.createNamespace(namespace2, (Map)newMeta);
        Database database2 = metastoreClient.getDatabase(namespace2.toString());
        Assert.assertEquals((String)"There no same location for db and namespace", (Object)database2.getLocationUri(), (Object)hiveLocalDir);
    }

    @Test
    public void testListNamespace() throws TException {
        Namespace namespace1 = Namespace.of((String[])new String[]{"dbname1"});
        catalog.createNamespace(namespace1, (Map)meta);
        List namespaces = catalog.listNamespaces(namespace1);
        Assert.assertTrue((String)"Hive db not hive the namespace 'dbname1'", (boolean)namespaces.isEmpty());
        Namespace namespace2 = Namespace.of((String[])new String[]{"dbname2"});
        catalog.createNamespace(namespace2, (Map)meta);
        namespaces = catalog.listNamespaces();
        Assert.assertTrue((String)"Hive db not hive the namespace 'dbname2'", (boolean)namespaces.contains(namespace2));
    }

    @Test
    public void testLoadNamespaceMeta() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_load"});
        catalog.createNamespace(namespace, (Map)meta);
        Map nameMata = catalog.loadNamespaceMetadata(namespace);
        Assert.assertTrue((boolean)((String)nameMata.get("owner")).equals("apache"));
        Assert.assertTrue((boolean)((String)nameMata.get("group")).equals("iceberg"));
        Assert.assertEquals((String)"There no same location for db and namespace", nameMata.get("location"), (Object)catalog.convertToDatabase(namespace, (Map)meta).getLocationUri());
    }

    @Test
    public void testNamespaceExists() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_exists"});
        catalog.createNamespace(namespace, (Map)meta);
        Assert.assertTrue((String)"Should true to namespace exist", (boolean)catalog.namespaceExists(namespace));
        Assert.assertTrue((String)"Should false to namespace doesn't exist", (!catalog.namespaceExists(Namespace.of((String[])new String[]{"db2", "db2", "ns2"})) ? 1 : 0) != 0);
    }

    @Test
    public void testSetNamespaceProperties() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_set"});
        catalog.createNamespace(namespace, (Map)meta);
        catalog.setProperties(namespace, (Map)ImmutableMap.of((Object)"owner", (Object)"alter_apache", (Object)"test", (Object)"test", (Object)"location", (Object)"file:/data/tmp", (Object)"comment", (Object)"iceberg test"));
        Database database = metastoreClient.getDatabase(namespace.level(0));
        Assert.assertEquals(database.getParameters().get("owner"), (Object)"alter_apache");
        Assert.assertEquals(database.getParameters().get("test"), (Object)"test");
        Assert.assertEquals(database.getParameters().get("group"), (Object)"iceberg");
        AssertHelpers.assertThrows((String)("Should fail to namespace not exist" + namespace), NoSuchNamespaceException.class, (String)"Namespace does not exist: ", () -> catalog.setProperties(Namespace.of((String[])new String[]{"db2", "db2", "ns2"}), (Map)meta));
    }

    @Test
    public void testRemoveNamespaceProperties() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_remove"});
        catalog.createNamespace(namespace, (Map)meta);
        catalog.removeProperties(namespace, (Set)ImmutableSet.of((Object)"comment", (Object)"owner"));
        Database database = metastoreClient.getDatabase(namespace.level(0));
        Assert.assertEquals(database.getParameters().get("owner"), null);
        Assert.assertEquals(database.getParameters().get("group"), (Object)"iceberg");
        AssertHelpers.assertThrows((String)("Should fail to namespace not exist" + namespace), NoSuchNamespaceException.class, (String)"Namespace does not exist: ", () -> catalog.removeProperties(Namespace.of((String[])new String[]{"db2", "db2", "ns2"}), (Set)ImmutableSet.of((Object)"comment", (Object)"owner")));
    }

    @Test
    public void testDropNamespace() throws TException {
        Namespace namespace = Namespace.of((String[])new String[]{"dbname_drop"});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)"table");
        Schema schema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
        catalog.createNamespace(namespace, (Map)meta);
        catalog.createTable(identifier, schema);
        Map nameMata = catalog.loadNamespaceMetadata(namespace);
        Assert.assertTrue((boolean)((String)nameMata.get("owner")).equals("apache"));
        Assert.assertTrue((boolean)((String)nameMata.get("group")).equals("iceberg"));
        AssertHelpers.assertThrows((String)("Should fail to drop namespace is not empty" + namespace), NamespaceNotEmptyException.class, (String)"Namespace dbname_drop is not empty. One or more tables exist.", () -> catalog.dropNamespace(namespace));
        Assert.assertTrue((boolean)catalog.dropTable(identifier, true));
        Assert.assertTrue((String)"Should fail to drop namespace if it is not empty", (boolean)catalog.dropNamespace(namespace));
        Assert.assertFalse((String)"Should fail to drop when namespace doesn't exist", (boolean)catalog.dropNamespace(Namespace.of((String[])new String[]{"db.ns1"})));
        AssertHelpers.assertThrows((String)("Should fail to drop namespace exist" + namespace), NoSuchNamespaceException.class, (String)"Namespace does not exist: ", () -> catalog.loadNamespaceMetadata(namespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableName() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).bucket("data", 16).build();
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            catalog.buildTable(tableIdent, schema).withPartitionSpec(spec).create();
            Table table = catalog.loadTable(tableIdent);
            Assert.assertEquals((String)"Name must match", (Object)"hive.hivedb.tbl", (Object)table.name());
            TableIdentifier snapshotsTableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl", "snapshots"});
            Table snapshotsTable = catalog.loadTable(snapshotsTableIdent);
            Assert.assertEquals((String)"Name must match", (Object)"hive.hivedb.tbl.snapshots", (Object)snapshotsTable.name());
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    private String defaultUri(Namespace namespace) throws TException {
        return metastoreClient.getConfigValue("hive.metastore.warehouse.dir", "") + "/" + namespace.level(0) + ".db";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUUIDinTableProperties() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.newFolder("tbl").toString();
        try {
            catalog.buildTable(tableIdentifier, schema).withLocation(location).create();
            Assert.assertNotNull((Object)this.hmsTableParameters().get("uuid"));
        }
        finally {
            catalog.dropTable(tableIdentifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotStatsTableProperties() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        TableIdentifier tableIdentifier = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        String location = this.temp.newFolder("tbl").toString();
        try {
            catalog.buildTable(tableIdentifier, schema).withLocation(location).create();
            Map<String, String> parameters = this.hmsTableParameters();
            Assert.assertEquals((Object)"0", (Object)parameters.get("snapshot-count"));
            Assert.assertNull((Object)parameters.get("current-snapshot-summary"));
            Assert.assertNull((Object)parameters.get("current-snapshot-id"));
            Assert.assertNull((Object)parameters.get("current-snapshot-timestamp-ms"));
            Table icebergTable = catalog.loadTable(tableIdentifier);
            String fileName = UUID.randomUUID().toString();
            DataFile file = DataFiles.builder((PartitionSpec)icebergTable.spec()).withPath(FileFormat.PARQUET.addExtension(fileName)).withRecordCount(2L).withFileSizeInBytes(0L).build();
            icebergTable.newFastAppend().appendFile(file).commit();
            parameters = this.hmsTableParameters();
            Assert.assertEquals((Object)"1", (Object)parameters.get("snapshot-count"));
            String summary = JsonUtil.mapper().writeValueAsString((Object)icebergTable.currentSnapshot().summary());
            Assert.assertEquals((Object)summary, (Object)parameters.get("current-snapshot-summary"));
            long snapshotId = icebergTable.currentSnapshot().snapshotId();
            Assert.assertEquals((Object)String.valueOf(snapshotId), (Object)parameters.get("current-snapshot-id"));
            Assert.assertEquals((Object)String.valueOf(icebergTable.currentSnapshot().timestampMillis()), (Object)parameters.get("current-snapshot-timestamp-ms"));
        }
        finally {
            catalog.dropTable(tableIdentifier);
        }
    }

    @Test
    public void testSetSnapshotSummary() throws Exception {
        Configuration conf = new Configuration();
        conf.set("iceberg.hive.table-property-max-size", "4000");
        HiveTableOperations ops = new HiveTableOperations(conf, null, null, catalog.name(), "hivedb", "tbl");
        Snapshot snapshot = (Snapshot)Mockito.mock(Snapshot.class);
        HashMap summary = Maps.newHashMap();
        Mockito.when((Object)snapshot.summary()).thenReturn((Object)summary);
        for (int i = 0; i < 100; ++i) {
            summary.put(String.valueOf(i), "value");
        }
        Assert.assertTrue((JsonUtil.mapper().writeValueAsString((Object)summary).length() < 4000 ? 1 : 0) != 0);
        HashMap parameters = Maps.newHashMap();
        ops.setSnapshotSummary((Map)parameters, snapshot);
        Assert.assertEquals((String)"The snapshot summary must be in parameters", (long)1L, (long)parameters.size());
        for (int i = 0; i < 1000; ++i) {
            summary.put(String.valueOf(i), "value");
        }
        long summarySize = JsonUtil.mapper().writeValueAsString((Object)summary).length();
        Assert.assertTrue((summarySize > 4000L && summarySize < 32672L ? 1 : 0) != 0);
        parameters.remove("current-snapshot-summary");
        ops.setSnapshotSummary((Map)parameters, snapshot);
        Assert.assertEquals((String)"The snapshot summary must not be in parameters due to the size limit", (long)0L, (long)parameters.size());
    }

    @Test
    public void testNotExposeTableProperties() {
        Configuration conf = new Configuration();
        conf.set("iceberg.hive.table-property-max-size", "0");
        HiveTableOperations ops = new HiveTableOperations(conf, null, null, catalog.name(), "hivedb", "tbl");
        TableMetadata metadata = (TableMetadata)Mockito.mock(TableMetadata.class);
        HashMap parameters = Maps.newHashMap();
        parameters.put("current-snapshot-summary", "summary");
        parameters.put("current-snapshot-id", "snapshotId");
        parameters.put("current-snapshot-timestamp-ms", "timestamp");
        parameters.put("current-schema", "schema");
        parameters.put("default-partition-spec", "partitionSpec");
        parameters.put("default-sort-order", "sortOrder");
        ops.setSnapshotStats(metadata, (Map)parameters);
        Assert.assertNull(parameters.get("current-snapshot-summary"));
        Assert.assertNull(parameters.get("current-snapshot-id"));
        Assert.assertNull(parameters.get("current-snapshot-timestamp-ms"));
        ops.setSchema(metadata, (Map)parameters);
        Assert.assertNull(parameters.get("current-schema"));
        ops.setPartitionSpec(metadata, (Map)parameters);
        Assert.assertNull(parameters.get("default-partition-spec"));
        ops.setSortOrder(metadata, (Map)parameters);
        Assert.assertNull(parameters.get("default-sort-order"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDefaultPartitionSpec() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.buildTable(tableIdent, schema).create();
            Assert.assertFalse((String)"Must not have default partition spec", (boolean)this.hmsTableParameters().containsKey("default-partition-spec"));
            table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
            Assert.assertEquals((Object)PartitionSpecParser.toJson((PartitionSpec)table.spec()), (Object)this.hmsTableParameters().get("default-partition-spec"));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetCurrentSchema() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        try {
            Table table = catalog.buildTable(tableIdent, schema).create();
            Assert.assertEquals((Object)SchemaParser.toJson((Schema)table.schema()), (Object)this.hmsTableParameters().get("current-schema"));
            UpdateSchema updateSchema = table.updateSchema();
            for (int i = 0; i < 600; ++i) {
                updateSchema.addColumn("new_col_" + i, (Type)Types.StringType.get());
            }
            updateSchema.commit();
            Assert.assertTrue((SchemaParser.toJson((Schema)table.schema()).length() > 32672 ? 1 : 0) != 0);
            Assert.assertNull((Object)this.hmsTableParameters().get("current-schema"));
        }
        finally {
            catalog.dropTable(tableIdent);
        }
    }

    private Map<String, String> hmsTableParameters() throws TException {
        org.apache.hadoop.hive.metastore.api.Table hmsTable = metastoreClient.getTable("hivedb", "tbl");
        return hmsTable.getParameters();
    }

    @Test
    public void testConstructorWarehousePathWithEndSlash() {
        HiveCatalog catalogWithSlash = new HiveCatalog();
        String wareHousePath = "s3://bucket/db/tbl";
        catalogWithSlash.initialize("hive_catalog", (Map)ImmutableMap.of((Object)"warehouse", (Object)(wareHousePath + "/")));
        Assert.assertEquals((String)"Should have trailing slash stripped", (Object)wareHousePath, (Object)catalogWithSlash.getConf().get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTablePropsDefinedAtCatalogLevel() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID")});
        TableIdentifier tableIdent = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
        ImmutableMap catalogProps = ImmutableMap.of((Object)"table-default.key1", (Object)"catalog-default-key1", (Object)"table-default.key2", (Object)"catalog-default-key2", (Object)"table-default.key3", (Object)"catalog-default-key3", (Object)"table-override.key3", (Object)"catalog-override-key3", (Object)"table-override.key4", (Object)"catalog-override-key4");
        Catalog hiveCatalog = CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)catalogProps, (Object)hiveConf);
        try {
            Table table = hiveCatalog.buildTable(tableIdent, schema).withProperty("key2", "table-key2").withProperty("key3", "table-key3").withProperty("key5", "table-key5").create();
            Assert.assertEquals((String)"Table defaults set for the catalog must be added to the table properties.", (Object)"catalog-default-key1", table.properties().get("key1"));
            Assert.assertEquals((String)"Table property must override table default properties set at catalog level.", (Object)"table-key2", table.properties().get("key2"));
            Assert.assertEquals((String)"Table property override set at catalog level must override table default properties set at catalog level and table property specified.", (Object)"catalog-override-key3", table.properties().get("key3"));
            Assert.assertEquals((String)"Table override not in table props or defaults should be added to table properties", (Object)"catalog-override-key4", table.properties().get("key4"));
            Assert.assertEquals((String)"Table properties without any catalog level default or override should be added to table properties.", (Object)"table-key5", table.properties().get("key5"));
        }
        finally {
            hiveCatalog.dropTable(tableIdent);
        }
    }
}

