/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestHiveCommitLocks
extends HiveTableBaseTest {
    private static HiveTableOperations spyOps = null;
    private static HiveClientPool spyClientPool = null;
    private static CachedClientPool spyCachedClientPool = null;
    private static Configuration overriddenHiveConf;
    private static AtomicReference<IMetaStoreClient> spyClientRef;
    private static IMetaStoreClient spyClient;
    HiveTableOperations ops = null;
    TableMetadata metadataV1 = null;
    TableMetadata metadataV2 = null;
    long dummyLockId = 500L;
    LockResponse waitLockResponse = new LockResponse(this.dummyLockId, LockState.WAITING);
    LockResponse acquiredLockResponse = new LockResponse(this.dummyLockId, LockState.ACQUIRED);
    LockResponse notAcquiredLockResponse = new LockResponse(this.dummyLockId, LockState.NOT_ACQUIRED);
    ShowLocksResponse emptyLocks = new ShowLocksResponse((List)Lists.newArrayList());

    @BeforeClass
    public static void startMetastore() throws Exception {
        HiveMetastoreTest.startMetastore((Map<String, String>)ImmutableMap.of((Object)HiveConf.ConfVars.HIVE_TXN_TIMEOUT.varname, (Object)"1s"));
        overriddenHiveConf = new Configuration((Configuration)hiveConf);
        overriddenHiveConf.setLong("iceberg.hive.lock-timeout-ms", 6000L);
        overriddenHiveConf.setLong("iceberg.hive.lock-check-min-wait-ms", 50L);
        overriddenHiveConf.setLong("iceberg.hive.lock-check-max-wait-ms", 5000L);
        overriddenHiveConf.setLong("iceberg.hive.lock-heartbeat-interval-ms", 100L);
        spyClientPool = (HiveClientPool)Mockito.spy((Object)new HiveClientPool(1, overriddenHiveConf));
        Mockito.when((Object)spyClientPool.newClient()).thenAnswer(invocation -> {
            IMetaStoreClient client = (IMetaStoreClient)Mockito.spy((Object)new HiveMetaStoreClient(hiveConf));
            spyClientRef.set(client);
            return spyClientRef.get();
        });
        spyClientPool.run(IMetaStoreClient::isLocalMetaStore);
        spyCachedClientPool = (CachedClientPool)Mockito.spy((Object)new CachedClientPool((Configuration)hiveConf, Collections.emptyMap()));
        Mockito.when((Object)spyCachedClientPool.clientPool()).thenAnswer(invocation -> spyClientPool);
        Assert.assertNotNull((Object)spyClientRef.get());
        spyClient = spyClientRef.get();
    }

    @Before
    public void before() throws Exception {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        this.ops = (HiveTableOperations)((HasTableOperations)table).operations();
        String dbName = TABLE_IDENTIFIER.namespace().level(0);
        String tableName = TABLE_IDENTIFIER.name();
        this.metadataV1 = this.ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        this.ops.refresh();
        this.metadataV2 = this.ops.current();
        Assert.assertEquals((long)2L, (long)this.ops.current().schema().columns().size());
        spyOps = (HiveTableOperations)Mockito.spy((Object)new HiveTableOperations(overriddenHiveConf, (ClientPool)spyCachedClientPool, this.ops.io(), catalog.name(), dbName, tableName));
        Mockito.reset((Object[])new IMetaStoreClient[]{spyClient});
    }

    @AfterClass
    public static void cleanup() {
        try {
            spyClientPool.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testLockAcquisitionAtFirstTime() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assert.assertEquals((long)1L, (long)spyOps.current().schema().columns().size());
    }

    @Test
    public void testLockAcquisitionAfterRetries() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assert.assertEquals((long)1L, (long)spyOps.current().schema().columns().size());
    }

    @Test
    public void testLockAcquisitionAfterFailedNotFoundLock() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.emptyLocks).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to connect to HMS")}).doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assert.assertEquals((long)1L, (long)spyOps.current().schema().columns().size());
    }

    @Test
    public void testLockAcquisitionAfterFailedAndFoundLock() throws TException, InterruptedException {
        ArgumentCaptor lockRequestCaptor = ArgumentCaptor.forClass(LockRequest.class);
        ((IMetaStoreClient)Mockito.doReturn((Object)this.emptyLocks).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to connect to HMS")}).doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)lockRequestCaptor.capture());
        ShowLocksResponse showLocksResponse = new ShowLocksResponse((List)Lists.newArrayList());
        ShowLocksResponseElementWrapper showLocksElement = new ShowLocksResponseElementWrapper(lockRequestCaptor);
        showLocksResponse.getLocks().add(showLocksElement);
        ((IMetaStoreClient)Mockito.doReturn((Object)showLocksResponse).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assert.assertEquals((long)1L, (long)spyOps.current().schema().columns().size());
    }

    @Test
    public void testUnLock() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testUnLockInterruptedUnLock() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)2))).unlock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testUnLockAfterInterruptedLock() throws TException {
        ArgumentCaptor lockRequestCaptor = ArgumentCaptor.forClass(LockRequest.class);
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).when((Object)spyClient)).lock((LockRequest)lockRequestCaptor.capture());
        ShowLocksResponse showLocksResponse = new ShowLocksResponse((List)Lists.newArrayList());
        ShowLocksResponseElementWrapper showLocksElement = new ShowLocksResponseElementWrapper(lockRequestCaptor);
        showLocksResponse.getLocks().add(showLocksElement);
        ((IMetaStoreClient)Mockito.doReturn((Object)showLocksResponse).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", RuntimeException.class, (String)"Interrupted while creating lock", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).lock((LockRequest)Mockito.any());
    }

    @Test
    public void testUnLockAfterInterruptedLockCheck() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", RuntimeException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).checkLock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testUnLockAfterInterruptedGetTable() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).when((Object)spyClient)).getTable((String)Mockito.any(), (String)Mockito.any());
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", RuntimeException.class, (String)"Interrupted during commit", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testLockFailureAtFirstTime() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.notAcquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testLockFailureAfterRetries() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.notAcquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testLockTimeoutAfterRetries() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Timed out after", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testPassThroughThriftExceptions() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doThrow(new Throwable[]{new TException("Test Thrift Exception")}).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", RuntimeException.class, (String)"Metastore operation failed for", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testPassThroughInterruptions() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doAnswer(invocation -> {
            Thread.currentThread().interrupt();
            Thread.sleep(10L);
            return this.waitLockResponse;
        }).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected an exception", CommitFailedException.class, (String)"Could not acquire the lock on", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    @Test
    public void testTableLevelProcessLockBlocksConcurrentHMSRequestsForSameTable() throws Exception {
        int numConcurrentCommits = 10;
        Mockito.reset((Object[])new IMetaStoreClient[]{spyClient});
        ExecutorService executor = Executors.newFixedThreadPool(numConcurrentCommits);
        IntStream.range(0, numConcurrentCommits).forEach(i -> executor.submit(() -> {
            try {
                spyOps.doCommit(this.metadataV2, this.metadataV1);
            }
            catch (CommitFailedException commitFailedException) {
                // empty catch block
            }
        }));
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).checkLock(((Long)Mockito.any(Long.class)).longValue());
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)numConcurrentCommits))).lock((LockRequest)Mockito.any(LockRequest.class));
    }

    @Test
    public void testLockHeartbeat() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((HiveTableOperations)Mockito.doAnswer((Answer)AdditionalAnswers.answersWithDelay((long)2000L, InvocationOnMock::callRealMethod)).when((Object)spyOps)).loadHmsTable();
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.atLeastOnce())).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testLockHeartbeatFailureDuringCommit() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((HiveTableOperations)Mockito.doAnswer((Answer)AdditionalAnswers.answersWithDelay((long)2000L, InvocationOnMock::callRealMethod)).when((Object)spyOps)).loadHmsTable();
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to heart beat.")}).when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        AssertHelpers.assertThrows((String)"Expected commit failure due to failure in heartbeat.", CommitFailedException.class, (String)"Failed to heartbeat for hive lock. Failed to heart beat.", () -> spyOps.doCommit(this.metadataV2, this.metadataV1));
    }

    static {
        spyClientRef = new AtomicReference();
        spyClient = null;
    }

    private class ShowLocksResponseElementWrapper
    extends ShowLocksResponseElement {
        private ArgumentCaptor<LockRequest> wrapped;

        private ShowLocksResponseElementWrapper(ArgumentCaptor<LockRequest> wrapped) {
            this.wrapped = wrapped;
        }

        public String getAgentInfo() {
            return ((LockRequest)this.wrapped.getValue()).getAgentInfo();
        }

        public LockState getState() {
            return LockState.WAITING;
        }

        public long getLockid() {
            return TestHiveCommitLocks.this.dummyLockId;
        }
    }
}

