/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class MetastoreUtil {
    private static final DynMethods.UnboundMethod ALTER_TABLE = DynMethods.builder((String)"alter_table").impl(IMetaStoreClient.class, "alter_table_with_environmentContext", new Class[]{String.class, String.class, Table.class, EnvironmentContext.class}).impl(IMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, Table.class, EnvironmentContext.class}).impl(IMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, Table.class}).build();

    private MetastoreUtil() {
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table) {
        MetastoreUtil.alterTable(client, databaseName, tblName, table, (Map<String, String>)ImmutableMap.of());
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table, Map<String, String> extraEnv) {
        HashMap env = Maps.newHashMapWithExpectedSize((int)(extraEnv.size() + 1));
        env.putAll(extraEnv);
        env.put("DO_NOT_UPDATE_STATS", "true");
        ALTER_TABLE.invoke((Object)client, new Object[]{databaseName, tblName, table, new EnvironmentContext((Map)env)});
    }
}

