/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hive.HiveMetastoreTest;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class HiveCreateReplaceTableTest
extends HiveMetastoreTest {
    private static final String TABLE_NAME = "tbl";
    private static final TableIdentifier TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
    @TempDir
    private Path temp;
    private String tableLocation;

    @BeforeEach
    public void createTableLocation() throws IOException {
        this.tableLocation = this.temp.resolve("hive-").toString();
    }

    @AfterEach
    public void cleanup() {
        catalog.dropTable(TABLE_IDENTIFIER);
    }

    @Test
    public void testCreateTableTxn() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        txn.updateProperties().set("prop", "value").commit();
        Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).isFalse();
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table props should match", new Object[0])).containsEntry((Object)"prop", (Object)"value");
    }

    @Test
    public void testCreateTableTxnTableCreatedConcurrently() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should be created", new Object[0])).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)txn).commitTransaction()).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: hivedb.tbl");
    }

    @Test
    public void testCreateTableTxnAndAppend() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        AppendFiles append = txn.newAppend();
        DataFile dataFile = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withRecordCount(1L).build();
        append.appendFile(dataFile);
        append.commit();
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        Snapshot snapshot = table.currentSnapshot();
        ((ListAssert)Assertions.assertThat((List)snapshot.allManifests(table.io())).as("Table should have one manifest file", new Object[0])).hasSize(1);
    }

    @Test
    public void testCreateTableTxnTableAlreadyExists() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should be created", new Object[0])).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap())).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: hivedb.tbl");
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testReplaceTableTxn(int formatVersion) {
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(formatVersion)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should exist", new Object[0])).isTrue();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, false);
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        if (formatVersion == 1) {
            PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("id", "id").withSpecId(1).build();
            ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Table should have a spec with one void field", new Object[0])).isEqualTo((Object)v1Expected);
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table spec must be unpartitioned", new Object[0])).isTrue();
        }
    }

    @Test
    public void testReplaceTableTxnTableNotExists() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, false)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: hivedb.tbl");
    }

    @Test
    public void testReplaceTableTxnTableDeletedConcurrently() {
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should exist", new Object[0])).isTrue();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, false);
        catalog.dropTable(TABLE_IDENTIFIER);
        txn.updateProperties().set("prop", "value").commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Transaction)txn).commitTransaction()).isInstanceOf(NoSuchTableException.class)).hasMessage("No such table: hivedb.tbl");
    }

    @Test
    public void testReplaceTableTxnTableModifiedConcurrently() {
        Table table = catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)Maps.newHashMap());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should exist", new Object[0])).isTrue();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, false);
        table.updateProperties().set("another-prop", "another-value").commit();
        txn.updateProperties().set("prop", "value").commit();
        txn.commitTransaction();
        table = catalog.loadTable(TABLE_IDENTIFIER);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table props should be updated", new Object[0])).doesNotContainKey((Object)"another-prop")).containsEntry((Object)"prop", (Object)"value");
    }

    @Test
    public void testCreateOrReplaceTableTxnTableNotExists() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, true);
        txn.updateProperties().set("prop", "value").commit();
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table props should match", new Object[0])).containsEntry((Object)"prop", (Object)"value");
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testCreateOrReplaceTableTxnTableExists(int formatVersion) {
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC, this.tableLocation, (Map)ImmutableMap.of((Object)"format-version", (Object)String.valueOf(formatVersion)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should exist", new Object[0])).isTrue();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, true);
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        if (formatVersion == 1) {
            PartitionSpec v1Expected = PartitionSpec.builderFor((Schema)table.schema()).alwaysNull("id", "id").withSpecId(1).build();
            ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Table should have a spec with one void field", new Object[0])).isEqualTo((Object)v1Expected);
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.spec().isUnpartitioned()).as("Table spec must be unpartitioned", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCreateOrReplaceTableTxnTableDeletedConcurrently() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should be created", new Object[0])).isTrue();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, PartitionSpec.unpartitioned(), this.tableLocation, (Map)Maps.newHashMap(), true);
        txn.updateProperties().set("prop", "value").commit();
        catalog.dropTable(TABLE_IDENTIFIER);
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table props should match", new Object[0])).containsEntry((Object)"prop", (Object)"value");
    }

    @Test
    public void testCreateOrReplaceTableTxnTableCreatedConcurrently() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        Transaction txn = catalog.newReplaceTableTransaction(TABLE_IDENTIFIER, SCHEMA, PartitionSpec.unpartitioned(), this.tableLocation, (Map)Maps.newHashMap(), true);
        txn.updateProperties().set("prop", "value").commit();
        catalog.createTable(TABLE_IDENTIFIER, SCHEMA, SPEC);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should be created", new Object[0])).isTrue();
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Partition spec should match", new Object[0])).isEqualTo((Object)PartitionSpec.unpartitioned());
        ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Table props should match", new Object[0])).containsEntry((Object)"prop", (Object)"value");
    }

    @Test
    public void testCreateTableTxnWithGlobalTableLocation() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        Transaction txn = catalog.newCreateTableTransaction(TABLE_IDENTIFIER, SCHEMA, SPEC, "file:///" + this.tableLocation, (Map)Maps.newHashMap());
        txn.commitTransaction();
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        DataFile dataFile = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(0L).withRecordCount(1L).build();
        table.newAppend().appendFile(dataFile).commit();
        ((IterableAssert)Assertions.assertThat((Iterable)table.snapshots()).as("Write should succeed", new Object[0])).hasSize(1);
    }
}

