/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public abstract class HiveMetastoreTest {
    protected static final String DB_NAME = "hivedb";
    protected static final long EVICTION_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    protected static HiveMetaStoreClient metastoreClient;
    protected static HiveCatalog catalog;
    protected static HiveConf hiveConf;
    protected static TestHiveMetastore metastore;

    @BeforeAll
    public static void startMetastore() throws Exception {
        HiveMetastoreTest.startMetastore(Collections.emptyMap());
    }

    public static void startMetastore(Map<String, String> hiveConfOverride) throws Exception {
        metastore = new TestHiveMetastore();
        HiveConf hiveConfWithOverrides = new HiveConf(TestHiveMetastore.class);
        if (hiveConfOverride != null) {
            for (Map.Entry<String, String> kv : hiveConfOverride.entrySet()) {
                hiveConfWithOverrides.set(kv.getKey(), kv.getValue());
            }
        }
        metastore.start(hiveConfWithOverrides);
        hiveConf = metastore.hiveConf();
        metastoreClient = new HiveMetaStoreClient(hiveConfWithOverrides);
        String dbPath = metastore.getDatabasePath(DB_NAME);
        Database db = new Database(DB_NAME, "description", dbPath, (Map)Maps.newHashMap());
        metastoreClient.createDatabase(db);
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(EVICTION_INTERVAL)), (Object)hiveConfWithOverrides);
    }

    @AfterAll
    public static void stopMetastore() throws Exception {
        catalog = null;
        metastoreClient.close();
        metastoreClient = null;
        metastore.stop();
        metastore = null;
    }
}

