/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Files;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class HiveTableTest
extends HiveTableBaseTest {
    static final String NON_DEFAULT_DATABASE = "nondefault";
    @TempDir
    private Path tempFolder;

    @Test
    public void testCreate() throws TException {
        String tableName = TABLE_IDENTIFIER.name();
        org.apache.hadoop.hive.metastore.api.Table table = HIVE_METASTORE_EXTENSION.metastoreClient().getTable(TABLE_IDENTIFIER.namespace().level(0), tableName);
        Map parameters = table.getParameters();
        Assertions.assertThat((Map)parameters).isNotNull();
        Assertions.assertThat((String)((String)parameters.get("table_type"))).isEqualToIgnoringCase((CharSequence)"iceberg");
        Assertions.assertThat((String)table.getTableType()).isEqualToIgnoringCase((CharSequence)"EXTERNAL_TABLE");
        Assertions.assertThat((String)table.getSd().getLocation()).isEqualTo(HiveTableTest.getTableLocation(tableName));
        Assertions.assertThat((int)table.getPartitionKeysSize()).isEqualTo(0);
        Assertions.assertThat(HiveTableTest.metadataVersionFiles(tableName)).hasSize(1);
        Assertions.assertThat(HiveTableTest.manifestFiles(tableName)).hasSize(0);
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        Assertions.assertThat((Object)icebergTable.schema().asStruct()).isEqualTo((Object)schema.asStruct());
    }

    @Test
    public void testRename() {
        String renamedTableName = "rename_table_name";
        TableIdentifier renameTableIdentifier = TableIdentifier.of((Namespace)TABLE_IDENTIFIER.namespace(), (String)renamedTableName);
        Table original = catalog.loadTable(TABLE_IDENTIFIER);
        catalog.renameTable(TABLE_IDENTIFIER, renameTableIdentifier);
        Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).isFalse();
        Assertions.assertThat((boolean)catalog.tableExists(renameTableIdentifier)).isTrue();
        Table renamed = catalog.loadTable(renameTableIdentifier);
        Assertions.assertThat((Object)renamed.schema().asStruct()).isEqualTo((Object)original.schema().asStruct());
        Assertions.assertThat((Object)renamed.spec()).isEqualTo((Object)original.spec());
        Assertions.assertThat((String)renamed.location()).isEqualTo(original.location());
        Assertions.assertThat((Object)renamed.currentSnapshot()).isEqualTo((Object)original.currentSnapshot());
        Assertions.assertThat((boolean)catalog.dropTable(renameTableIdentifier)).isTrue();
    }

    @Test
    public void testDrop() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should exist", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.dropTable(TABLE_IDENTIFIER)).as("Drop should return true and drop the table", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
    }

    @Test
    public void testDropWithoutPurgeLeavesTableData() throws IOException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        String fileLocation = this.appendData(table, "file");
        String manifestListLocation = table.currentSnapshot().manifestListLocation().replace("file:", "");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.dropTable(TABLE_IDENTIFIER, false)).as("Drop should return true and drop the table", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(fileLocation)).as("Table data files should exist", new Object[0])).exists();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(manifestListLocation)).as("Table metadata files should exist", new Object[0])).exists();
    }

    @Test
    public void testDropTable() throws IOException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)schema, (String)"test"));
        ArrayList records = Lists.newArrayList((Object[])new GenericData.Record[]{recordBuilder.set("id", (Object)1L).build(), recordBuilder.set("id", (Object)2L).build(), recordBuilder.set("id", (Object)3L).build()});
        String location1 = table.location().replace("file:", "") + "/data/file1.avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)location1)).schema(schema).named("test").build();){
            for (Object rec : records) {
                writer.add(rec);
            }
        }
        String location2 = table.location().replace("file:", "") + "/data/file2.avro";
        Object object = null;
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)location2)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        catch (Throwable rec) {
            object = rec;
            throw rec;
        }
        DataFile file1 = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(location1).withFileSizeInBytes(Files.localInput((String)location2).getLength()).build();
        DataFile file2 = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(location2).withFileSizeInBytes(Files.localInput((String)location1).getLength()).build();
        table.newAppend().appendFile(file1).appendFile(file2).commit();
        table.newDelete().deleteFile(file2.path()).commit();
        String manifestListLocation = table.currentSnapshot().manifestListLocation().replace("file:", "");
        List manifests = table.currentSnapshot().allManifests(table.io());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.dropTable(TABLE_IDENTIFIER)).as("Drop (table and data) should return true and drop the table", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).as("Table should not exist", new Object[0])).isFalse();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(location1)).as("Table data files should not exist", new Object[0])).doesNotExist();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(location2)).as("Table data files should not exist", new Object[0])).doesNotExist();
        ((AbstractFileAssert)Assertions.assertThat((File)new File(manifestListLocation)).as("Table manifest list files should not exist", new Object[0])).doesNotExist();
        for (ManifestFile manifest : manifests) {
            ((AbstractFileAssert)Assertions.assertThat((File)new File(manifest.path().replace("file:", ""))).as("Table manifest files should not exist", new Object[0])).doesNotExist();
        }
        ((AbstractFileAssert)Assertions.assertThat((File)new File(((HasTableOperations)table).operations().current().metadataFileLocation().replace("file:", ""))).as("Table metadata file should not exist", new Object[0])).doesNotExist();
    }

    @Test
    public void testExistingTableUpdate() throws TException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).commit();
        icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        Assertions.assertThat(HiveTableTest.metadataVersionFiles("tbl")).hasSize(2);
        Assertions.assertThat(HiveTableTest.manifestFiles("tbl")).hasSize(0);
        Assertions.assertThat((Object)icebergTable.schema().asStruct()).isEqualTo((Object)altered.asStruct());
        org.apache.hadoop.hive.metastore.api.Table table = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        List hiveColumns = table.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
        List icebergColumns = altered.columns().stream().map(Types.NestedField::name).collect(Collectors.toList());
        Assertions.assertThat(hiveColumns).isEqualTo(icebergColumns);
    }

    @Test
    public void testColumnTypeChangeInMetastore() throws TException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        Schema expectedSchema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"string", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"int", (Type)Types.IntegerType.get())}).fields());
        icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).addColumn("string", (Type)Types.StringType.get()).addColumn("int", (Type)Types.IntegerType.get()).commit();
        ((ObjectAssert)Assertions.assertThat((Object)icebergTable.schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        expectedSchema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"int", (Type)Types.IntegerType.get())}).fields());
        icebergTable.updateSchema().deleteColumn("string").commit();
        ((ObjectAssert)Assertions.assertThat((Object)icebergTable.schema().asStruct()).as("Schema should match expected", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
    }

    @Test
    public void testFailure() throws TException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        org.apache.hadoop.hive.metastore.api.Table table = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        String dummyLocation = "dummylocation";
        table.getParameters().put("metadata_location", dummyLocation);
        HIVE_METASTORE_EXTENSION.metastoreClient().alter_table("hivedb", "tbl", table);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).commit()).isInstanceOf(CommitFailedException.class)).hasMessageContaining("is not same as the current table metadata location 'dummylocation'");
    }

    @Test
    public void testListTables() throws TException, IOException {
        List tableIdents = catalog.listTables(TABLE_IDENTIFIER.namespace());
        List expectedIdents = tableIdents.stream().filter(t -> t.namespace().level(0).equals("hivedb") && t.name().equals("tbl")).collect(Collectors.toList());
        Assertions.assertThat(expectedIdents).hasSize(1);
        Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).isTrue();
        String hiveTableName = "test_hive_table";
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.createHiveTable(hiveTableName);
        HIVE_METASTORE_EXTENSION.metastoreClient().createTable(hiveTable);
        catalog.setListAllTables(false);
        List tableIdents1 = catalog.listTables(TABLE_IDENTIFIER.namespace());
        ((ListAssert)Assertions.assertThat((List)tableIdents1).as("should only 1 iceberg table .", new Object[0])).hasSize(1);
        catalog.setListAllTables(true);
        List tableIdents2 = catalog.listTables(TABLE_IDENTIFIER.namespace());
        ((ListAssert)Assertions.assertThat((List)tableIdents2).as("should be 2 tables in namespace .", new Object[0])).hasSize(2);
        Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).isTrue();
        HIVE_METASTORE_EXTENSION.metastoreClient().dropTable("hivedb", hiveTableName);
    }

    private org.apache.hadoop.hive.metastore.api.Table createHiveTable(String hiveTableName) throws IOException {
        HashMap parameters = Maps.newHashMap();
        parameters.put("serialization.class", "org.apache.hadoop.hive.serde2.thrift.test.IntString");
        parameters.put("serialization.format", "org.apache.thrift.protocol.TBinaryProtocol");
        SerDeInfo serDeInfo = new SerDeInfo(null, "org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer", (Map)parameters);
        StorageDescriptor sd = new StorageDescriptor((List)Lists.newArrayList(), this.tempFolder.toAbsolutePath().toString(), "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.mapred.TextOutputFormat", false, -1, serDeInfo, (List)Lists.newArrayList(), (List)Lists.newArrayList(), (Map)Maps.newHashMap());
        org.apache.hadoop.hive.metastore.api.Table hiveTable = new org.apache.hadoop.hive.metastore.api.Table(hiveTableName, "hivedb", "test_owner", 0, 0, 0, sd, (List)Lists.newArrayList(), (Map)Maps.newHashMap(), "viewOriginalText", "viewExpandedText", TableType.EXTERNAL_TABLE.name());
        return hiveTable;
    }

    @Test
    public void testNonDefaultDatabaseLocation() throws IOException, TException {
        Namespace namespace = Namespace.of((String[])new String[]{NON_DEFAULT_DATABASE});
        File nonDefaultLocation = java.nio.file.Files.createTempDirectory(NON_DEFAULT_DATABASE, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
        catalog.createNamespace(namespace, Collections.singletonMap("location", nonDefaultLocation.getPath()));
        Map namespaceMeta = catalog.loadNamespaceMetadata(namespace);
        Assertions.assertThat((String)("file:" + nonDefaultLocation.getPath())).isEqualTo((String)namespaceMeta.get("location"));
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl");
        catalog.createTable(tableIdentifier, schema);
        Table table = catalog.loadTable(tableIdentifier);
        Assertions.assertThat((String)table.location()).isEqualTo((String)namespaceMeta.get("location") + "/" + "tbl");
        HIVE_METASTORE_EXTENSION.metastoreClient().dropDatabase(NON_DEFAULT_DATABASE, true, true, true);
    }

    @Test
    public void testRegisterTable() throws TException {
        org.apache.hadoop.hive.metastore.api.Table originalTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        Map originalParams = originalTable.getParameters();
        Assertions.assertThat((Map)originalParams).isNotNull();
        Assertions.assertThat((String)((String)originalParams.get("table_type"))).isEqualToIgnoringCase((CharSequence)"iceberg");
        Assertions.assertThat((String)originalTable.getTableType()).isEqualToIgnoringCase((CharSequence)"EXTERNAL_TABLE");
        catalog.dropTable(TABLE_IDENTIFIER, false);
        Assertions.assertThat((boolean)catalog.tableExists(TABLE_IDENTIFIER)).isFalse();
        List<String> metadataVersionFiles = HiveTableTest.metadataVersionFiles("tbl");
        Assertions.assertThat(metadataVersionFiles).hasSize(1);
        catalog.registerTable(TABLE_IDENTIFIER, "file:" + metadataVersionFiles.get(0));
        org.apache.hadoop.hive.metastore.api.Table newTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        Map newTableParameters = newTable.getParameters();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)newTableParameters).doesNotContainKey((Object)"previous_metadata_location")).containsEntry((Object)"table_type", (Object)((String)originalParams.get("table_type")))).containsEntry((Object)"metadata_location", (Object)((String)originalParams.get("metadata_location")));
        Assertions.assertThat((Comparable)newTable.getSd()).isEqualTo((Object)originalTable.getSd());
    }

    @Test
    public void testRegisterHadoopTableToHiveCatalog() throws IOException, TException {
        String tableLocation = this.tempFolder.toString();
        HadoopCatalog hadoopCatalog = new HadoopCatalog(new Configuration(), tableLocation);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"hivedb", "table1"});
        Table table = hadoopCatalog.createTable(identifier, schema, PartitionSpec.unpartitioned(), (Map)Maps.newHashMap());
        String file1Location = this.appendData(table, "file1");
        ArrayList tasks = Lists.newArrayList((Iterable)table.newScan().planFiles());
        ((ListAssert)Assertions.assertThat((List)tasks).as("Should scan 1 file", new Object[0])).hasSize(1);
        Assertions.assertThat((String)file1Location).isEqualTo((Object)((DataFile)((FileScanTask)tasks.get(0)).file()).path());
        List metadataFiles = Arrays.stream(new File(table.location() + "/metadata").listFiles()).map(File::getAbsolutePath).filter(f -> f.endsWith(TableMetadataParser.getFileExtension((TableMetadataParser.Codec)TableMetadataParser.Codec.NONE))).collect(Collectors.toList());
        Assertions.assertThat(metadataFiles).hasSize(2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "table1")).isInstanceOf(NoSuchObjectException.class)).hasMessage("hivedb.table1 table not found");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadTable(identifier)).isInstanceOf(NoSuchTableException.class)).hasMessage("Table does not exist: hivedb.table1");
        String latestMetadataFile = ((BaseTable)table).operations().current().metadataFileLocation();
        catalog.registerTable(identifier, "file:" + latestMetadataFile);
        Assertions.assertThat((Comparable)HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "table1")).isNotNull();
        table = catalog.loadTable(identifier);
        Assertions.assertThat((Object)table).isNotNull();
        String file2Location = this.appendData(table, "file2");
        tasks = Lists.newArrayList((Iterable)table.newScan().planFiles());
        ((ListAssert)Assertions.assertThat((List)tasks).as("Should scan 2 files", new Object[0])).hasSize(2);
        Set files = tasks.stream().map(task -> ((DataFile)task.file()).path().toString()).collect(Collectors.toSet());
        Assertions.assertThat(files).contains((Object[])new String[]{file1Location, file2Location});
    }

    private String appendData(Table table, String fileName) throws IOException {
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)schema, (String)"test"));
        ArrayList records = Lists.newArrayList((Object[])new GenericData.Record[]{recordBuilder.set("id", (Object)1L).build(), recordBuilder.set("id", (Object)2L).build(), recordBuilder.set("id", (Object)3L).build()});
        String fileLocation = table.location().replace("file:", "") + "/data/" + fileName + ".avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)fileLocation)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        DataFile file = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(fileLocation).withFileSizeInBytes(Files.localInput((String)fileLocation).getLength()).build();
        table.newAppend().appendFile(file).commit();
        return fileLocation;
    }

    @Test
    public void testRegisterExistingTable() throws TException {
        org.apache.hadoop.hive.metastore.api.Table originalTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        Map originalParams = originalTable.getParameters();
        Assertions.assertThat((Map)originalParams).isNotNull();
        Assertions.assertThat((String)((String)originalParams.get("table_type"))).isEqualToIgnoringCase((CharSequence)"iceberg");
        Assertions.assertThat((String)originalTable.getTableType()).isEqualToIgnoringCase((CharSequence)"EXTERNAL_TABLE");
        List<String> metadataVersionFiles = HiveTableTest.metadataVersionFiles("tbl");
        Assertions.assertThat(metadataVersionFiles).hasSize(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.registerTable(TABLE_IDENTIFIER, "file:" + (String)metadataVersionFiles.get(0))).isInstanceOf(AlreadyExistsException.class)).hasMessage("Table already exists: hivedb.tbl");
    }

    @Test
    public void testEngineHiveEnabledDefault() throws TException {
        catalog.dropTable(TABLE_IDENTIFIER);
        catalog.getConf().unset("iceberg.engine.hive.enabled");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, false);
    }

    @Test
    public void testEngineHiveEnabledConfig() throws TException {
        catalog.dropTable(TABLE_IDENTIFIER);
        catalog.getConf().set("iceberg.engine.hive.enabled", "true");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, true);
        catalog.dropTable(TABLE_IDENTIFIER);
        catalog.getConf().set("iceberg.engine.hive.enabled", "false");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned());
        hmsTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, false);
    }

    @Test
    public void testEngineHiveEnabledTableProperty() throws TException {
        catalog.dropTable(TABLE_IDENTIFIER);
        HashMap tableProperties = Maps.newHashMap();
        tableProperties.put("engine.hive.enabled", "true");
        catalog.getConf().set("iceberg.engine.hive.enabled", "false");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned(), (Map)tableProperties);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, true);
        catalog.dropTable(TABLE_IDENTIFIER);
        tableProperties.put("engine.hive.enabled", "false");
        catalog.getConf().set("iceberg.engine.hive.enabled", "true");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned(), (Map)tableProperties);
        hmsTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, false);
    }

    @Test
    public void testMissingMetadataWontCauseHang() {
        catalog.loadTable(TABLE_IDENTIFIER);
        File realLocation = new File(HiveTableTest.metadataLocation("tbl"));
        File fakeLocation = new File(HiveTableTest.metadataLocation("tbl") + "_dummy");
        Assertions.assertThat((boolean)realLocation.renameTo(fakeLocation)).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.loadTable(TABLE_IDENTIFIER)).isInstanceOf(NotFoundException.class)).hasMessageStartingWith("Failed to open input stream for file");
        Assertions.assertThat((boolean)fakeLocation.renameTo(realLocation)).isTrue();
    }

    private void assertHiveEnabled(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean expected) {
        if (expected) {
            Assertions.assertThat((Map)hmsTable.getParameters()).containsEntry((Object)"storage_handler", (Object)"org.apache.iceberg.mr.hive.HiveIcebergStorageHandler");
            Assertions.assertThat((String)hmsTable.getSd().getSerdeInfo().getSerializationLib()).isEqualTo("org.apache.iceberg.mr.hive.HiveIcebergSerDe");
            Assertions.assertThat((String)hmsTable.getSd().getInputFormat()).isEqualTo("org.apache.iceberg.mr.hive.HiveIcebergInputFormat");
            Assertions.assertThat((String)hmsTable.getSd().getOutputFormat()).isEqualTo("org.apache.iceberg.mr.hive.HiveIcebergOutputFormat");
        } else {
            Assertions.assertThat((Map)hmsTable.getParameters()).doesNotContainKey((Object)"storage_handler");
            Assertions.assertThat((String)hmsTable.getSd().getSerdeInfo().getSerializationLib()).isEqualTo("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
            Assertions.assertThat((String)hmsTable.getSd().getInputFormat()).isEqualTo("org.apache.hadoop.mapred.FileInputFormat");
            Assertions.assertThat((String)hmsTable.getSd().getOutputFormat()).isEqualTo("org.apache.hadoop.mapred.FileOutputFormat");
        }
    }
}

