/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.RuntimeMetaException;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.thrift.transport.TTransportException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHiveClientPool {
    private static final String HIVE_SITE_CONTENT = "<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration>\n  <property>\n    <name>hive.metastore.sasl.enabled</name>\n    <value>true</value>\n  </property>\n</configuration>\n";
    HiveClientPool clients;

    @BeforeEach
    public void before() {
        HiveClientPool clientPool = new HiveClientPool(2, new Configuration());
        this.clients = (HiveClientPool)Mockito.spy((Object)clientPool);
    }

    @AfterEach
    public void after() {
        this.clients.close();
        this.clients = null;
    }

    @Test
    public void testConf() {
        HiveConf conf = this.createHiveConf();
        conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, "file:/mywarehouse/");
        HiveClientPool clientPool = new HiveClientPool(10, (Configuration)conf);
        HiveConf clientConf = clientPool.hiveConf();
        Assertions.assertThat((String)clientConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname)).isEqualTo(conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
        Assertions.assertThat((int)clientPool.poolSize()).isEqualTo(10);
        Assertions.assertThat((String)clientConf.get(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname)).isEqualTo(conf.get(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname));
        Assertions.assertThat((boolean)clientConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL)).isTrue();
    }

    private HiveConf createHiveConf() {
        HiveConf hiveConf = new HiveConf();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(HIVE_SITE_CONTENT.getBytes(StandardCharsets.UTF_8));){
            hiveConf.addResource((InputStream)inputStream, "for_test");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hiveConf;
    }

    @Test
    public void testNewClientFailure() {
        ((HiveClientPool)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Connection exception")}).when((Object)this.clients)).newClient();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            String cfr_ignored_0 = (String)this.clients.run(Object::toString);
        }).isInstanceOf(RuntimeException.class)).hasMessage("Connection exception");
    }

    @Test
    public void testGetTablesFailsForNonReconnectableException() throws Exception {
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        ((HiveClientPool)Mockito.doReturn((Object)hmsClient).when((Object)this.clients)).newClient();
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new MetaException("Another meta exception")}).when((Object)hmsClient)).getTables(Mockito.anyString(), Mockito.anyString());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            List cfr_ignored_0 = (List)this.clients.run(client -> client.getTables("default", "t"));
        }).isInstanceOf(MetaException.class)).hasMessage("Another meta exception");
    }

    @Test
    public void testExceptionMessages() {
        try (MockedStatic mockedStatic = Mockito.mockStatic(MetaStoreUtils.class);){
            mockedStatic.when(() -> MetaStoreUtils.newInstance((Class)((Class)ArgumentMatchers.any()), (Class[])((Class[])ArgumentMatchers.any()), (Object[])((Object[])ArgumentMatchers.any()))).thenThrow(new Throwable[]{new RuntimeException((Throwable)new MetaException("Another meta exception"))});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                List cfr_ignored_0 = (List)this.clients.run(client -> client.getTables("default", "t"));
            }).isInstanceOf(RuntimeMetaException.class)).hasMessage("Failed to connect to Hive Metastore");
        }
        mockedStatic = Mockito.mockStatic(MetaStoreUtils.class);
        var2_2 = null;
        try {
            mockedStatic.when(() -> MetaStoreUtils.newInstance((Class)((Class)ArgumentMatchers.any()), (Class[])((Class[])ArgumentMatchers.any()), (Object[])((Object[])ArgumentMatchers.any()))).thenThrow(new Throwable[]{new RuntimeException((Throwable)new MetaException())});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                List cfr_ignored_0 = (List)this.clients.run(client -> client.getTables("default", "t"));
            }).isInstanceOf(RuntimeMetaException.class)).hasMessage("Failed to connect to Hive Metastore");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (mockedStatic != null) {
                TestHiveClientPool.$closeResource(var2_2, (AutoCloseable)mockedStatic);
            }
        }
        mockedStatic = Mockito.mockStatic(MetaStoreUtils.class);
        var2_2 = null;
        try {
            mockedStatic.when(() -> MetaStoreUtils.newInstance((Class)((Class)ArgumentMatchers.any()), (Class[])((Class[])ArgumentMatchers.any()), (Object[])((Object[])ArgumentMatchers.any()))).thenThrow(new Throwable[]{new RuntimeException()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                List cfr_ignored_0 = (List)this.clients.run(client -> client.getTables("default", "t"));
            }).isInstanceOf(RuntimeMetaException.class)).hasMessage("Failed to connect to Hive Metastore");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (mockedStatic != null) {
                TestHiveClientPool.$closeResource(var2_2, (AutoCloseable)mockedStatic);
            }
        }
        mockedStatic = Mockito.mockStatic(MetaStoreUtils.class);
        var2_2 = null;
        try {
            mockedStatic.when(() -> MetaStoreUtils.newInstance((Class)((Class)ArgumentMatchers.any()), (Class[])((Class[])ArgumentMatchers.any()), (Object[])((Object[])ArgumentMatchers.any()))).thenThrow(new Throwable[]{new RuntimeException("Another instance of Derby may have already booted")});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
                List cfr_ignored_0 = (List)this.clients.run(client -> client.getTables("default", "t"));
            }).isInstanceOf(RuntimeMetaException.class)).hasMessage("Failed to start an embedded metastore because embedded Derby supports only one client at a time. To fix this, use a metastore that supports multiple clients.");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (mockedStatic != null) {
                TestHiveClientPool.$closeResource(var2_2, (AutoCloseable)mockedStatic);
            }
        }
    }

    @Test
    public void testConnectionFailureRestoreForMetaException() throws Exception {
        HiveMetaStoreClient hmsClient = this.newClient();
        String metaMessage = "Got exception: org.apache.thrift.transport.TTransportException";
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new MetaException(metaMessage)}).when((Object)hmsClient)).getAllDatabases();
        HiveMetaStoreClient newClient = this.reconnect(hmsClient);
        ArrayList databases = Lists.newArrayList((Object[])new String[]{"db1", "db2"});
        ((HiveMetaStoreClient)Mockito.doReturn((Object)databases).when((Object)newClient)).getAllDatabases();
        Assertions.assertThat((List)((List)this.clients.run(client -> client.getAllDatabases(), true))).isEqualTo((Object)databases);
        ((HiveClientPool)Mockito.verify((Object)this.clients)).reconnect((IMetaStoreClient)hmsClient);
        ((HiveClientPool)Mockito.verify((Object)this.clients, (VerificationMode)Mockito.never())).reconnect((IMetaStoreClient)newClient);
    }

    @Test
    public void testConnectionFailureRestoreForTTransportException() throws Exception {
        HiveMetaStoreClient hmsClient = this.newClient();
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TTransportException()}).when((Object)hmsClient)).getAllFunctions();
        HiveMetaStoreClient newClient = this.reconnect(hmsClient);
        GetAllFunctionsResponse response = new GetAllFunctionsResponse();
        response.addToFunctions(new Function("concat", "db1", "classname", "root", PrincipalType.USER, 100, FunctionType.JAVA, null));
        ((HiveMetaStoreClient)Mockito.doReturn((Object)response).when((Object)newClient)).getAllFunctions();
        Assertions.assertThat((Comparable)((GetAllFunctionsResponse)this.clients.run(client -> client.getAllFunctions(), true))).isEqualTo((Object)response);
        ((HiveClientPool)Mockito.verify((Object)this.clients)).reconnect((IMetaStoreClient)hmsClient);
        ((HiveClientPool)Mockito.verify((Object)this.clients, (VerificationMode)Mockito.never())).reconnect((IMetaStoreClient)newClient);
    }

    private HiveMetaStoreClient newClient() {
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        ((HiveClientPool)Mockito.doReturn((Object)hmsClient).when((Object)this.clients)).newClient();
        return hmsClient;
    }

    private HiveMetaStoreClient reconnect(HiveMetaStoreClient obsoleteClient) {
        HiveMetaStoreClient newClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        ((HiveClientPool)Mockito.doReturn((Object)newClient).when((Object)this.clients)).reconnect((IMetaStoreClient)obsoleteClient);
        return newClient;
    }
}

