/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveMetastoreExtension;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;

public class HiveTableBaseTest {
    static final String TABLE_NAME = "tbl";
    static final String DB_NAME = "hivedb";
    static final TableIdentifier TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{"hivedb", "tbl"});
    @RegisterExtension
    protected static final HiveMetastoreExtension HIVE_METASTORE_EXTENSION = HiveMetastoreExtension.builder().withDatabase("hivedb").build();
    protected static HiveCatalog catalog;
    static final Schema SCHEMA;
    static final Schema ALTERED;
    private static final PartitionSpec PARTITION_SPEC;
    private Path tableLocation;

    @BeforeAll
    public static void initCatalog() {
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(10L))), (Object)HIVE_METASTORE_EXTENSION.hiveConf());
    }

    @BeforeEach
    public void createTestTable() {
        this.tableLocation = new Path(catalog.createTable(TABLE_IDENTIFIER, SCHEMA, PARTITION_SPEC).location());
    }

    @AfterEach
    public void dropTestTable() throws Exception {
        this.tableLocation.getFileSystem((Configuration)HIVE_METASTORE_EXTENSION.hiveConf()).delete(this.tableLocation, true);
        catalog.dropTable(TABLE_IDENTIFIER, false);
    }

    private static String getTableBasePath(String tableName) {
        String databasePath = HIVE_METASTORE_EXTENSION.metastore().getDatabasePath(DB_NAME);
        return Paths.get(databasePath, tableName).toAbsolutePath().toString();
    }

    protected static Path getTableLocationPath(String tableName) {
        return new Path("file", null, Paths.get(HiveTableBaseTest.getTableBasePath(tableName), new String[0]).toString());
    }

    protected static String getTableLocation(String tableName) {
        return HiveTableBaseTest.getTableLocationPath(tableName).toString();
    }

    protected static String metadataLocation(String tableName) {
        return Paths.get(HiveTableBaseTest.getTableBasePath(tableName), "metadata").toString();
    }

    private static List<String> metadataFiles(String tableName) {
        return Arrays.stream(new File(HiveTableBaseTest.metadataLocation(tableName)).listFiles()).map(File::getAbsolutePath).collect(Collectors.toList());
    }

    protected static List<String> metadataVersionFiles(String tableName) {
        return HiveTableBaseTest.filterByExtension(tableName, TableMetadataParser.getFileExtension((TableMetadataParser.Codec)TableMetadataParser.Codec.NONE));
    }

    protected static List<String> manifestFiles(String tableName) {
        return HiveTableBaseTest.filterByExtension(tableName, ".avro");
    }

    private static List<String> filterByExtension(String tableName, String extension) {
        return HiveTableBaseTest.metadataFiles(tableName).stream().filter(f -> f.endsWith(extension)).collect(Collectors.toList());
    }

    static {
        SCHEMA = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
        ALTERED = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get())}).fields());
        PARTITION_SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
    }
}

