/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HiveLock;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.hive.LockException;
import org.apache.iceberg.hive.NoLock;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicReferenceAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHiveCommits
extends HiveTableBaseTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuppressUnlockExceptions() {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        AtomicReference lockRef = new AtomicReference();
        Mockito.when((Object)spyOps.lockObject(metadataV2)).thenAnswer(i -> {
            HiveLock lock = (HiveLock)i.callRealMethod();
            lockRef.set(lock);
            return lock;
        });
        try {
            spyOps.commit(metadataV2, metadataV1);
            HiveLock spyLock = (HiveLock)Mockito.spy((Object)((HiveLock)lockRef.get()));
            ((HiveLock)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)spyLock)).unlock();
        }
        finally {
            ((HiveLock)lockRef.get()).unlock();
        }
        ops.refresh();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(1);
    }

    @Test
    public void testThriftExceptionUnknownStateIfNotInHistoryFailureOnCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.failCommitAndThrowException(spyOps);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on fire");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should not have changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(ops.current())).as("New metadata files should still exist, new location not in history but the commit may still succeed", new Object[0])).isEqualTo(3);
    }

    @Test
    public void testThriftExceptionSuccessOnCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.commitAndThrowException(ops, spyOps);
        spyOps.commit(metadataV2, metadataV1);
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should have changed", new Object[0])).isNotEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(ops.current())).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(ops.current())).as("Commit should have been successful and new metadata file should be made", new Object[0])).isEqualTo(3);
    }

    @Test
    public void testThriftExceptionUnknownFailedCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.failCommitAndThrowException(spyOps);
        this.breakFallbackCatalogCommitCheck(spyOps);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on fire");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should not have changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(ops.current())).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(ops.current())).as("Client could not determine outcome so new metadata file should also exist", new Object[0])).isEqualTo(3);
    }

    @Test
    public void testThriftExceptionsUnknownSuccessCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        this.commitAndThrowException(ops, spyOps);
        this.breakFallbackCatalogCommitCheck(spyOps);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on fire");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should have changed", new Object[0])).isNotEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(ops.current())).as("Current metadata file should still exist", new Object[0])).isTrue();
    }

    @Test
    public void testThriftExceptionConcurrentCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        AtomicReference<HiveLock> lock = new AtomicReference<HiveLock>();
        ((HiveTableOperations)Mockito.doAnswer(l -> {
            lock.set(ops.lockObject(metadataV2));
            return lock.get();
        }).when((Object)spyOps)).lockObject(metadataV2);
        this.concurrentCommitAndThrowException(ops, spyOps, table, lock);
        spyOps.commit(metadataV2, metadataV1);
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should have changed", new Object[0])).isNotEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(ops.current())).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((ListAssert)Assertions.assertThat((List)ops.current().schema().columns()).as("The column addition from the concurrent commit should have been successful", new Object[0])).hasSize(2);
    }

    @Test
    public void testInvalidObjectException() {
        TableIdentifier badTi = TableIdentifier.of((String[])new String[]{"hivedb", "`tbl`"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.createTable(badTi, SCHEMA, PartitionSpec.unpartitioned())).isInstanceOf(ValidationException.class)).hasMessage(String.format("Invalid Hive object for %s.%s", "hivedb", "`tbl`"));
    }

    @Test
    public void testAlreadyExistsException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> catalog.createTable(TABLE_IDENTIFIER, SCHEMA, PartitionSpec.unpartitioned())).isInstanceOf(AlreadyExistsException.class)).hasMessage(String.format("Table already exists: %s.%s", "hivedb", "tbl"));
    }

    @Test
    public void testNoLockThriftExceptionConcurrentCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        ((HiveTableOperations)Mockito.doReturn((Object)new NoLock()).when((Object)spyOps)).lockObject((TableMetadata)Mockito.any());
        ((HiveTableOperations)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("MetaException(message:The table has been modified. The parameter value for key 'metadata_location' is")}).when((Object)spyOps)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessage("The table hivedb.tbl has been modified concurrently");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should not have changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(ops.current())).as("New metadata files should not exist", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testLockExceptionUnknownSuccessCommit() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        TableMetadata metadataV2 = ops.current();
        Assertions.assertThat((List)ops.current().schema().columns()).hasSize(2);
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            org.apache.hadoop.hive.metastore.api.Table tbl = (org.apache.hadoop.hive.metastore.api.Table)i.getArgument(0, org.apache.hadoop.hive.metastore.api.Table.class);
            String location = (String)i.getArgument(2, String.class);
            ops.persistTable(tbl, true, location);
            throw new LockException("Datacenter on fire", new Object[0]);
        }).when((Object)spyOps)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).hasMessageContaining("Failed to heartbeat for hive lock while").isInstanceOf(CommitStateUnknownException.class);
        ops.refresh();
        ((AbstractStringAssert)Assertions.assertThat((String)ops.current().location()).as("Current metadata should have changed to metadata V1", new Object[0])).isEqualTo(metadataV1.location());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(ops.current())).as("Current metadata file should still exist", new Object[0])).isTrue();
    }

    @Test
    public void testCommitExceptionWithoutMessage() throws TException, InterruptedException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata metadataV1 = ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        ops.refresh();
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        ((HiveTableOperations)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)spyOps)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(ops.current(), metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("null\nCannot determine whether the commit was successful or not");
    }

    @Test
    public void testChangeLockWithAlterTable() throws Exception {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        HiveTableOperations ops = (HiveTableOperations)((HasTableOperations)table).operations();
        TableMetadata base = ops.current();
        HiveLock initialLock = ops.lockObject(base);
        AtomicReference lockRef = new AtomicReference();
        HiveTableOperations spyOps = (HiveTableOperations)Mockito.spy((Object)ops);
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            lockRef.set(ops.lockObject((TableMetadata)i.getArgument(0)));
            return lockRef.get();
        }).when((Object)spyOps)).lockObject(base);
        TableMetadata newMetadata = TableMetadata.buildFrom((TableMetadata)base).setProperties((Map)ImmutableMap.of((Object)"engine.hive.lock-enabled", (Object)(initialLock instanceof NoLock ? "true" : "false"))).build();
        spyOps.commit(base, newMetadata);
        ((AtomicReferenceAssert)Assertions.assertThat(lockRef).as("Lock not captured by the stub", new Object[0])).doesNotHaveNullValue();
        ((ObjectAssert)Assertions.assertThat((Object)((HiveLock)lockRef.get())).as("New lock mechanism shouldn't take effect before the commit completes", new Object[0])).hasSameClassAs((Object)initialLock);
    }

    private void commitAndThrowException(HiveTableOperations realOperations, HiveTableOperations spyOperations) throws TException, InterruptedException {
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            org.apache.hadoop.hive.metastore.api.Table tbl = (org.apache.hadoop.hive.metastore.api.Table)i.getArgument(0, org.apache.hadoop.hive.metastore.api.Table.class);
            String location = (String)i.getArgument(2, String.class);
            realOperations.persistTable(tbl, true, location);
            throw new TException("Datacenter on fire");
        }).when((Object)spyOperations)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
    }

    private void concurrentCommitAndThrowException(HiveTableOperations realOperations, HiveTableOperations spyOperations, Table table, AtomicReference<HiveLock> lock) throws TException, InterruptedException {
        ((HiveTableOperations)Mockito.doAnswer(i -> {
            org.apache.hadoop.hive.metastore.api.Table tbl = (org.apache.hadoop.hive.metastore.api.Table)i.getArgument(0, org.apache.hadoop.hive.metastore.api.Table.class);
            String location = (String)i.getArgument(2, String.class);
            realOperations.persistTable(tbl, true, location);
            ((HiveLock)lock.get()).unlock();
            table.refresh();
            table.updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).commit();
            throw new TException("Datacenter on fire");
        }).when((Object)spyOperations)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
    }

    private void failCommitAndThrowException(HiveTableOperations spyOperations) throws TException, InterruptedException {
        ((HiveTableOperations)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Datacenter on fire")}).when((Object)spyOperations)).persistTable((org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
    }

    private void breakFallbackCatalogCommitCheck(HiveTableOperations spyOperations) {
        Mockito.when((Object)spyOperations.refresh()).thenThrow(new Throwable[]{new RuntimeException("Still on fire")});
    }

    private boolean metadataFileExists(TableMetadata metadata) {
        return new File(metadata.metadataFileLocation().replace("file:", "")).exists();
    }

    private int metadataFileCount(TableMetadata metadata) {
        return new File(metadata.metadataFileLocation().replace("file:", "")).getParentFile().listFiles(file -> file.getName().endsWith("metadata.json")).length;
    }
}

