/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchIcebergViewException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveMetastoreExtension;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewCatalogTests;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestHiveViewCatalog
extends ViewCatalogTests<HiveCatalog> {
    private HiveCatalog catalog;
    @RegisterExtension
    private static final HiveMetastoreExtension HIVE_METASTORE_EXTENSION = HiveMetastoreExtension.builder().build();

    @BeforeEach
    public void before() throws TException {
        this.catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(10L))), (Object)HIVE_METASTORE_EXTENSION.hiveConf());
    }

    @AfterEach
    public void cleanup() throws Exception {
        HIVE_METASTORE_EXTENSION.metastore().reset();
    }

    protected HiveCatalog catalog() {
        return this.catalog;
    }

    protected Catalog tableCatalog() {
        return this.catalog;
    }

    protected boolean requiresNamespaceCreate() {
        return true;
    }

    @Test
    public void testHiveViewAndIcebergViewWithSameName() throws TException, IOException {
        String dbName = "hivedb";
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        String viewName = "test_hive_view";
        TableIdentifier identifier = TableIdentifier.of((Namespace)ns, (String)viewName);
        if (this.requiresNamespaceCreate()) {
            this.catalog.createNamespace(identifier.namespace());
        }
        Assertions.assertThat((List)this.catalog.listViews(ns)).isEmpty();
        Table hiveTable = this.createHiveView(viewName, dbName, Files.createTempDirectory("hive-view-tests-name", new FileAttribute[0]).toString());
        HIVE_METASTORE_EXTENSION.metastoreClient().createTable(hiveTable);
        this.catalog.setListAllTables(true);
        ((ListAssert)Assertions.assertThat((List)this.catalog.listTables(ns)).containsExactly((Object[])new TableIdentifier[]{identifier})).hasSize(1);
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.catalog.buildView(identifier).withSchema(SCHEMA)).withDefaultNamespace(ns)).withQuery("hive", "select * from hivedb.tbl")).create()).isInstanceOf(NoSuchIcebergViewException.class)).hasMessageStartingWith("Not an iceberg view: hive.hivedb.test_hive_view");
    }

    @Test
    public void testListViewWithHiveView() throws TException, IOException {
        String dbName = "hivedb";
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        TableIdentifier identifier = TableIdentifier.of((Namespace)ns, (String)"test_iceberg_view");
        if (this.requiresNamespaceCreate()) {
            this.catalog.createNamespace(identifier.namespace());
        }
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isFalse();
        Assertions.assertThat((List)this.catalog.listViews(ns)).isEmpty();
        String hiveViewName = "test_hive_view";
        Table hiveTable = this.createHiveView(hiveViewName, dbName, Files.createTempDirectory("hive-view-tests-list", new FileAttribute[0]).toString());
        HIVE_METASTORE_EXTENSION.metastoreClient().createTable(hiveTable);
        this.catalog.setListAllTables(true);
        ((ListAssert)Assertions.assertThat((List)this.catalog.listTables(ns)).containsExactly((Object[])new TableIdentifier[]{TableIdentifier.of((Namespace)ns, (String)hiveViewName)})).hasSize(1);
        Assertions.assertThat((List)this.catalog.listViews(ns)).hasSize(0);
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.catalog.buildView(identifier).withSchema(SCHEMA)).withDefaultNamespace(ns)).withQuery("hive", "select * from hivedb.tbl")).create();
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isTrue();
        ((ListAssert)Assertions.assertThat((List)this.catalog.listViews(ns)).containsExactly((Object[])new TableIdentifier[]{identifier})).hasSize(1);
    }

    @Test
    public void testViewWithHiveParameters() throws TException, IOException {
        String dbName = "hivedb";
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        TableIdentifier identifier = TableIdentifier.of((Namespace)ns, (String)"test_iceberg_view");
        if (this.requiresNamespaceCreate()) {
            this.catalog.createNamespace(identifier.namespace());
        }
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isFalse();
        String tableQuery = "select * from hivedb.tbl";
        ((ViewBuilder)((ViewBuilder)((ViewBuilder)this.catalog.buildView(identifier).withSchema(SCHEMA)).withDefaultNamespace(ns)).withQuery("hive", tableQuery)).create();
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isTrue();
        Table hiveTable = HIVE_METASTORE_EXTENSION.metastoreClient().getTable(dbName, identifier.name());
        Assertions.assertThat((String)hiveTable.getViewOriginalText()).isEqualTo(tableQuery);
        Assertions.assertThat((String)hiveTable.getViewExpandedText()).isEqualTo(tableQuery);
    }

    @Test
    public void testInvalidIdentifiersWithRename() {
        TableIdentifier invalidFrom = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"l1", "l2"}), (String)"view");
        TableIdentifier validTo = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"l1"}), (String)"renamedView");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.renameView(invalidFrom, validTo)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid identifier: " + invalidFrom);
        TableIdentifier validFrom = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"l1"}), (String)"view");
        TableIdentifier invalidTo = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"l1", "l2"}), (String)"renamedView");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.renameView(validFrom, invalidTo)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid identifier: " + invalidTo);
    }

    @Test
    public void dropViewShouldNotDropMetadataFileIfGcNotEnabled() throws IOException {
        String dbName = "hivedb";
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        TableIdentifier identifier = TableIdentifier.of((Namespace)ns, (String)"test_iceberg_drop_view_gc_disabled");
        if (this.requiresNamespaceCreate()) {
            this.catalog.createNamespace(identifier.namespace());
        }
        BaseView view = (BaseView)((ViewBuilder)((ViewBuilder)((ViewBuilder)this.catalog.buildView(identifier).withSchema(SCHEMA)).withDefaultNamespace(ns)).withQuery("hive", "select * from hivedb.tbl")).withProperty("gc.enabled", "false").create();
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isTrue();
        Path viewLocation = new Path(view.location());
        String currentMetadataLocation = view.operations().current().metadataFileLocation();
        this.catalog.dropView(identifier);
        Assertions.assertThat((boolean)viewLocation.getFileSystem((Configuration)HIVE_METASTORE_EXTENSION.hiveConf()).exists(new Path(currentMetadataLocation))).isTrue();
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isFalse();
    }

    @Test
    public void dropViewShouldDropMetadataFileIfGcEnabled() throws IOException {
        String dbName = "hivedb";
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        TableIdentifier identifier = TableIdentifier.of((Namespace)ns, (String)"test_iceberg_drop_view_gc_enabled");
        if (this.requiresNamespaceCreate()) {
            this.catalog.createNamespace(identifier.namespace());
        }
        BaseView view = (BaseView)((ViewBuilder)((ViewBuilder)((ViewBuilder)this.catalog.buildView(identifier).withSchema(SCHEMA)).withDefaultNamespace(ns)).withQuery("hive", "select * from hivedb.tbl")).withProperty("gc.enabled", "true").create();
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isTrue();
        Path viewLocation = new Path(view.location());
        String currentMetadataLocation = view.operations().current().metadataFileLocation();
        Assertions.assertThat((boolean)viewLocation.getFileSystem((Configuration)HIVE_METASTORE_EXTENSION.hiveConf()).exists(new Path(currentMetadataLocation))).isTrue();
        this.catalog.dropView(identifier);
        Assertions.assertThat((boolean)viewLocation.getFileSystem((Configuration)HIVE_METASTORE_EXTENSION.hiveConf()).exists(new Path(currentMetadataLocation))).isFalse();
        Assertions.assertThat((boolean)this.catalog.viewExists(identifier)).isFalse();
    }

    private Table createHiveView(String hiveViewName, String dbName, String location) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("serialization.class", "org.apache.hadoop.hive.serde2.thrift.test.IntString");
        parameters.put("serialization.format", "org.apache.thrift.protocol.TBinaryProtocol");
        SerDeInfo serDeInfo = new SerDeInfo(null, "org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer", (Map)parameters);
        StorageDescriptor sd = new StorageDescriptor((List)Lists.newArrayList(), location, "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.mapred.TextOutputFormat", false, -1, serDeInfo, (List)Lists.newArrayList(), (List)Lists.newArrayList(), (Map)Maps.newHashMap());
        Table hiveTable = new Table(hiveViewName, dbName, "test_owner", 0, 0, 0, sd, (List)Lists.newArrayList(), (Map)Maps.newHashMap(), "viewOriginalText", "viewExpandedText", TableType.VIRTUAL_VIEW.name());
        return hiveTable;
    }
}

