/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveLock;
import org.apache.iceberg.hive.HiveMetastoreExtension;
import org.apache.iceberg.hive.HiveViewOperations;
import org.apache.iceberg.hive.LockException;
import org.apache.iceberg.hive.NoLock;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

public class TestHiveViewCommits {
    private static final String VIEW_NAME = "test_iceberg_view";
    private static final String DB_NAME = "hivedb";
    private static final Namespace NS = Namespace.of((String[])new String[]{"hivedb"});
    private static final Schema SCHEMA = new Schema(5, new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get(), (String)"unique ID"), Types.NestedField.required((int)4, (String)"data", (Type)Types.StringType.get())});
    private static final TableIdentifier VIEW_IDENTIFIER = TableIdentifier.of((Namespace)NS, (String)"test_iceberg_view");
    @RegisterExtension
    protected static final HiveMetastoreExtension HIVE_METASTORE_EXTENSION = HiveMetastoreExtension.builder().withDatabase("hivedb").build();
    private View view;
    private Path viewLocation;
    private static HiveCatalog catalog;

    @BeforeAll
    public static void initCatalog() {
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(10L))), (Object)HIVE_METASTORE_EXTENSION.hiveConf());
    }

    @BeforeEach
    public void createTestView() {
        this.view = ((ViewBuilder)((ViewBuilder)((ViewBuilder)catalog.buildView(VIEW_IDENTIFIER).withSchema(SCHEMA)).withDefaultNamespace(NS)).withQuery("hive", "select * from ns.tbl")).create();
        this.viewLocation = new Path(this.view.location());
    }

    @AfterEach
    public void dropTestView() throws IOException {
        this.viewLocation.getFileSystem((Configuration)HIVE_METASTORE_EXTENSION.hiveConf()).delete(this.viewLocation, true);
        catalog.dropView(VIEW_IDENTIFIER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuppressUnlockExceptions() {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k1", (Object)"v1");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        AtomicReference lockRef = new AtomicReference();
        Mockito.when((Object)spyOps.lockObject()).thenAnswer(i -> {
            HiveLock lock = (HiveLock)i.callRealMethod();
            lockRef.set(lock);
            return lock;
        });
        try {
            spyOps.commit(metadataV2, metadataV1);
            HiveLock spyLock = (HiveLock)Mockito.spy((Object)((HiveLock)lockRef.get()));
            ((HiveLock)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)spyLock)).unlock();
        }
        finally {
            ((HiveLock)lockRef.get()).unlock();
        }
        ops.refresh();
        ((MapAssert)Assertions.assertThat((Map)ops.current().properties()).hasSize(0)).isEqualTo((Object)metadataV1.properties());
    }

    @Test
    public void testThriftExceptionUnknownStateIfNotInHistoryFailureOnCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k1", (Object)"v1");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        this.failCommitAndThrowException(spyOps);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on fire");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should not have changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(metadataV2)).as("New metadata files should still exist, new location not in history but the commit may still succeed", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testThriftExceptionSuccessOnCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k1", (Object)"v1");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        this.commitAndThrowException(ops, spyOps);
        spyOps.commit(metadataV2, metadataV1);
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should have not changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(metadataV2)).as("Commit should have been successful and new metadata file should be made", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testThriftExceptionUnknownFailedCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k1", (Object)"v1");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        this.failCommitAndThrowException(spyOps);
        this.breakFallbackCatalogCommitCheck(spyOps);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on fire");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should not have changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(metadataV2)).as("Client could not determine outcome so new metadata file should also exist", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testThriftExceptionsUnknownSuccessCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        Assertions.assertThat((Map)metadataV2.properties()).hasSize(1);
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        this.commitAndThrowException(ops, spyOps);
        this.breakFallbackCatalogCommitCheck(spyOps);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("Datacenter on fire");
        ops.refresh();
        ViewMetadata metadataV3 = ops.current();
        ((ObjectAssert)Assertions.assertThat((Object)metadataV3).as("Current metadata should have changed", new Object[0])).isNotEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV3)).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(metadataV3)).as("Commit should have been successful with updated properties at metadataV2", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testThriftExceptionConcurrentCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k0", "v0").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k0", (Object)"v0");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        AtomicReference<HiveLock> lock = new AtomicReference<HiveLock>();
        ((HiveViewOperations)Mockito.doAnswer(l -> {
            lock.set(ops.lockObject());
            return lock.get();
        }).when((Object)spyOps)).lockObject();
        this.concurrentCommitAndThrowException(ops, spyOps, (BaseView)this.view, lock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageContaining("Datacenter on fire");
        ops.refresh();
        ViewMetadata metadataV3 = ops.current();
        ((ObjectAssert)Assertions.assertThat((Object)metadataV3).as("Current metadata should have changed", new Object[0])).isNotEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV3)).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((MapAssert)Assertions.assertThat((Map)metadataV3.properties()).as("The new properties from the concurrent commit should have been successful", new Object[0])).hasSize(2);
    }

    @Test
    public void testInvalidObjectException() {
        TableIdentifier badTi = TableIdentifier.of((String[])new String[]{DB_NAME, "`test_iceberg_view`"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ViewBuilder)((ViewBuilder)((ViewBuilder)catalog.buildView(badTi).withSchema(SCHEMA)).withDefaultNamespace(NS)).withQuery("hive", "select * from ns.tbl")).create()).isInstanceOf(ValidationException.class)).hasMessage("Invalid Hive object for hivedb.`test_iceberg_view`");
    }

    @Test
    public void testNoLockThriftExceptionConcurrentCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k1", (Object)"v1");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        ((HiveViewOperations)Mockito.doReturn((Object)new NoLock()).when((Object)spyOps)).lockObject();
        ((HiveViewOperations)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("MetaException(message:The table has been modified. The parameter value for key 'metadata_location' is")}).when((Object)spyOps)).persistTable((Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessageContaining("The view hivedb.test_iceberg_view has been modified concurrently");
        ops.refresh();
        ((ObjectAssert)Assertions.assertThat((Object)ops.current()).as("Current metadata should not have changed", new Object[0])).isEqualTo((Object)metadataV2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(metadataV2)).as("New metadata files should not exist", new Object[0])).isEqualTo(1);
    }

    @Test
    public void testLockExceptionUnknownSuccessCommit() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        ViewMetadata metadataV2 = ops.current();
        ((MapAssert)Assertions.assertThat((Map)metadataV2.properties()).hasSize(1)).containsEntry((Object)"k1", (Object)"v1");
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        ((HiveViewOperations)Mockito.doAnswer(i -> {
            Table tbl = (Table)i.getArgument(0, Table.class);
            String location = (String)i.getArgument(2, String.class);
            ops.persistTable(tbl, true, location);
            throw new LockException("Datacenter on fire", new Object[0]);
        }).when((Object)spyOps)).persistTable((Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        Assertions.assertThatThrownBy(() -> spyOps.commit(metadataV2, metadataV1)).hasMessageContaining("Failed to heartbeat for hive lock while").isInstanceOf(CommitStateUnknownException.class);
        ops.refresh();
        ((AbstractStringAssert)Assertions.assertThat((String)metadataV2.location()).as("Current metadata should have changed to metadata V1", new Object[0])).isEqualTo(metadataV1.location());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.metadataFileExists(metadataV2)).as("Current metadata file should still exist", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.metadataFileCount(metadataV2)).as("New metadata file should exist", new Object[0])).isEqualTo(2);
    }

    @Test
    public void testCommitExceptionWithoutMessage() throws TException, InterruptedException {
        HiveViewOperations ops = (HiveViewOperations)((BaseView)this.view).operations();
        ViewMetadata metadataV1 = ops.current();
        Assertions.assertThat((Map)metadataV1.properties()).hasSize(0);
        this.view.updateProperties().set("k1", "v1").commit();
        ops.refresh();
        HiveViewOperations spyOps = (HiveViewOperations)Mockito.spy((Object)ops);
        ((HiveViewOperations)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)spyOps)).persistTable((Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.commit(ops.current(), metadataV1)).isInstanceOf(CommitStateUnknownException.class)).hasMessageStartingWith("null\nCannot determine whether the commit was successful or not");
    }

    private void commitAndThrowException(HiveViewOperations realOperations, HiveViewOperations spyOperations) throws TException, InterruptedException {
        ((HiveViewOperations)Mockito.doAnswer(i -> {
            Table tbl = (Table)i.getArgument(0, Table.class);
            String location = (String)i.getArgument(2, String.class);
            realOperations.persistTable(tbl, true, location);
            throw new TException("Datacenter on fire");
        }).when((Object)spyOperations)).persistTable((Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
    }

    private void concurrentCommitAndThrowException(HiveViewOperations realOperations, HiveViewOperations spyOperations, BaseView baseView, AtomicReference<HiveLock> lock) throws TException, InterruptedException {
        ((HiveViewOperations)Mockito.doAnswer(i -> {
            Table tbl = (Table)i.getArgument(0, Table.class);
            String location = (String)i.getArgument(2, String.class);
            realOperations.persistTable(tbl, true, location);
            ((HiveLock)lock.get()).unlock();
            baseView.operations().refresh();
            baseView.updateProperties().set("k1", "v1").set("k2", "v2").commit();
            throw new TException("Datacenter on fire");
        }).when((Object)spyOperations)).persistTable((Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
    }

    private void failCommitAndThrowException(HiveViewOperations spyOperations) throws TException, InterruptedException {
        ((HiveViewOperations)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Datacenter on fire")}).when((Object)spyOperations)).persistTable((Table)Mockito.any(), Mockito.anyBoolean(), (String)Mockito.any());
    }

    private void breakFallbackCatalogCommitCheck(HiveViewOperations spyOperations) {
        Mockito.when((Object)spyOperations.refresh()).thenThrow(new Throwable[]{new RuntimeException("Still on fire")});
    }

    private boolean metadataFileExists(ViewMetadata metadata) {
        return new File(metadata.metadataFileLocation().replace("file:", "")).exists();
    }

    private int metadataFileCount(ViewMetadata metadata) {
        return new File(metadata.metadataFileLocation().replace("file:", "")).getParentFile().listFiles(file -> file.getName().endsWith("metadata.json")).length;
    }
}

