/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

abstract class BaseEntriesTable
extends BaseMetadataTable {
    BaseEntriesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public Schema schema() {
        Types.StructType partitionType = Partitioning.partitionType(this.table());
        Schema schema = ManifestEntry.getSchema(partitionType);
        if (partitionType.fields().size() < 1) {
            schema = TypeUtil.selectNot(schema, Sets.newHashSet(102));
        }
        return TypeUtil.join(schema, MetricsUtil.readableMetricsSchema(this.table().schema(), schema));
    }

    static CloseableIterable<FileScanTask> planFiles(Table table, CloseableIterable<ManifestFile> manifests, Schema tableSchema, Schema projectedSchema, TableScanContext context) {
        Expression rowFilter = context.rowFilter();
        boolean caseSensitive = context.caseSensitive();
        boolean ignoreResiduals = context.ignoreResiduals();
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = BaseFilesTable.transformSpec(tableSchema, spec);
            return ManifestEvaluator.forRowFilter(rowFilter, transformedSpec, caseSensitive);
        });
        CloseableIterable<ManifestFile> filteredManifests = CloseableIterable.filter(manifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        String schemaString = SchemaParser.toJson(projectedSchema);
        String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
        Expression filter = ignoreResiduals ? Expressions.alwaysTrue() : rowFilter;
        ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
        return CloseableIterable.transform(filteredManifests, manifest -> new ManifestReadTask(table, (ManifestFile)manifest, projectedSchema, schemaString, specString, residuals));
    }

    static class ManifestReadTask
    extends BaseFileScanTask
    implements DataTask {
        private final Schema projection;
        private final Schema fileProjection;
        private final Schema dataTableSchema;
        private final FileIO io;
        private final ManifestFile manifest;
        private final Map<Integer, PartitionSpec> specsById;

        ManifestReadTask(Table table, ManifestFile manifest, Schema projection, String schemaString, String specString, ResidualEvaluator residuals) {
            super(DataFiles.fromManifest(manifest), null, schemaString, specString, residuals);
            this.projection = projection;
            this.io = table.io();
            this.manifest = manifest;
            this.specsById = Maps.newHashMap(table.specs());
            this.dataTableSchema = table.schema();
            Type fileProjectionType = projection.findType("data_file");
            this.fileProjection = fileProjectionType != null ? new Schema(fileProjectionType.asStructType().fields()) : new Schema(new Types.NestedField[0]);
        }

        @VisibleForTesting
        ManifestFile manifest() {
            return this.manifest;
        }

        @Override
        public CloseableIterable<StructLike> rows() {
            Types.NestedField readableMetricsField = this.projection.findField("readable_metrics");
            if (readableMetricsField == null) {
                StructProjection structProjection = this.structProjection(this.projection);
                return CloseableIterable.transform(this.entries(this.fileProjection), entry -> structProjection.wrap((StructLike)((Object)entry)));
            }
            Schema requiredFileProjection = this.requiredFileProjection();
            Schema actualProjection = this.removeReadableMetrics(this.projection, readableMetricsField);
            StructProjection structProjection = this.structProjection(actualProjection);
            return CloseableIterable.transform(this.entries(requiredFileProjection), entry -> this.withReadableMetrics(structProjection, (ManifestEntry<? extends ContentFile<?>>)entry, readableMetricsField));
        }

        private Schema requiredFileProjection() {
            Schema projectionForReadableMetrics = new Schema(MetricsUtil.READABLE_METRIC_COLS.stream().map(MetricsUtil.ReadableMetricColDefinition::originalCol).collect(Collectors.toList()));
            return TypeUtil.join(this.fileProjection, projectionForReadableMetrics);
        }

        private Schema removeReadableMetrics(Schema projectionSchema, Types.NestedField readableMetricsField) {
            Set<Integer> readableMetricsIds = TypeUtil.getProjectedIds(readableMetricsField.type());
            return TypeUtil.selectNot(projectionSchema, readableMetricsIds);
        }

        private StructProjection structProjection(Schema projectedSchema) {
            Schema manifestEntrySchema = ManifestEntry.wrapFileSchema(this.fileProjection.asStruct());
            return StructProjection.create(manifestEntrySchema, projectedSchema);
        }

        private CloseableIterable<? extends ManifestEntry<? extends ContentFile<?>>> entries(Schema fileStructProjection) {
            return ManifestFiles.open(this.manifest, this.io, this.specsById).project(fileStructProjection).entries();
        }

        private StructLike withReadableMetrics(StructProjection structProjection, ManifestEntry<? extends ContentFile<?>> entry, Types.NestedField readableMetricsField) {
            StructProjection struct = structProjection.wrap((StructLike)((Object)entry));
            int structSize = this.projection.columns().size();
            MetricsUtil.ReadableMetricsStruct readableMetrics = this.readableMetrics(entry.file(), readableMetricsField);
            int metricsPosition = this.projection.columns().indexOf(readableMetricsField);
            return new MetricsUtil.StructWithReadableMetrics(struct, structSize, readableMetrics, metricsPosition);
        }

        private MetricsUtil.ReadableMetricsStruct readableMetrics(ContentFile<?> file, Types.NestedField readableMetricsField) {
            Types.StructType projectedMetricType = readableMetricsField.type().asStructType();
            return MetricsUtil.readableMetricsStruct(this.dataTableSchema, file, projectedMetricType);
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }
}

