/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseScan;
import org.apache.iceberg.IncrementalScan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.events.IncrementalScanEvent;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.SnapshotUtil;

abstract class BaseIncrementalScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
extends BaseScan<ThisT, T, G>
implements IncrementalScan<ThisT, T, G> {
    protected BaseIncrementalScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    protected abstract CloseableIterable<T> doPlanFiles(Long var1, long var2);

    @Override
    public ThisT fromSnapshotInclusive(long fromSnapshotId) {
        Preconditions.checkArgument(this.table().snapshot(fromSnapshotId) != null, "Cannot find the starting snapshot: %s", fromSnapshotId);
        TableScanContext newContext = this.context().fromSnapshotIdInclusive(fromSnapshotId);
        return this.newRefinedScan(this.table(), this.schema(), newContext);
    }

    @Override
    public ThisT fromSnapshotExclusive(long fromSnapshotId) {
        TableScanContext newContext = this.context().fromSnapshotIdExclusive(fromSnapshotId);
        return this.newRefinedScan(this.table(), this.schema(), newContext);
    }

    @Override
    public ThisT toSnapshot(long toSnapshotId) {
        Preconditions.checkArgument(this.table().snapshot(toSnapshotId) != null, "Cannot find the end snapshot: %s", toSnapshotId);
        TableScanContext newContext = this.context().toSnapshotId(toSnapshotId);
        return this.newRefinedScan(this.table(), this.schema(), newContext);
    }

    @Override
    public CloseableIterable<T> planFiles() {
        if (this.scanCurrentLineage() && this.table().currentSnapshot() == null) {
            return CloseableIterable.empty();
        }
        long toSnapshotIdInclusive = this.toSnapshotIdInclusive();
        Long fromSnapshotIdExclusive = this.fromSnapshotIdExclusive(toSnapshotIdInclusive);
        if (fromSnapshotIdExclusive != null) {
            Listeners.notifyAll(new IncrementalScanEvent(this.table().name(), fromSnapshotIdExclusive, toSnapshotIdInclusive, this.filter(), this.schema(), false));
        } else {
            Listeners.notifyAll(new IncrementalScanEvent(this.table().name(), SnapshotUtil.oldestAncestorOf(this.table(), toSnapshotIdInclusive).snapshotId(), toSnapshotIdInclusive, this.filter(), this.schema(), true));
        }
        return this.doPlanFiles(fromSnapshotIdExclusive, toSnapshotIdInclusive);
    }

    private boolean scanCurrentLineage() {
        return this.context().fromSnapshotId() == null && this.context().toSnapshotId() == null;
    }

    private long toSnapshotIdInclusive() {
        if (this.context().toSnapshotId() != null) {
            return this.context().toSnapshotId();
        }
        Snapshot currentSnapshot = this.table().currentSnapshot();
        Preconditions.checkArgument(currentSnapshot != null, "End snapshot is not set and table has no current snapshot");
        return currentSnapshot.snapshotId();
    }

    private Long fromSnapshotIdExclusive(long toSnapshotIdInclusive) {
        Long fromSnapshotId = this.context().fromSnapshotId();
        boolean fromSnapshotInclusive = this.context().fromSnapshotInclusive();
        if (fromSnapshotId == null) {
            return null;
        }
        if (fromSnapshotInclusive) {
            Preconditions.checkArgument(SnapshotUtil.isAncestorOf(this.table(), toSnapshotIdInclusive, fromSnapshotId), "Starting snapshot (inclusive) %s is not an ancestor of end snapshot %s", (Object)fromSnapshotId, toSnapshotIdInclusive);
            return this.table().snapshot(fromSnapshotId).parentId();
        }
        Preconditions.checkArgument(SnapshotUtil.isParentAncestorOf(this.table(), toSnapshotIdInclusive, fromSnapshotId), "Starting snapshot (exclusive) %s is not a parent ancestor of end snapshot %s", (Object)fromSnapshotId, toSnapshotIdInclusive);
        return fromSnapshotId;
    }
}

