/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.Scan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PropertyUtil;

abstract class BaseScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
implements Scan<ThisT, T, G> {
    protected static final List<String> SCAN_COLUMNS = ImmutableList.of("snapshot_id", "file_path", "file_ordinal", "file_format", "block_size_in_bytes", "file_size_in_bytes", "record_count", "partition", "key_metadata", "split_offsets");
    private static final List<String> STATS_COLUMNS = ImmutableList.of("value_counts", "null_value_counts", "nan_value_counts", "lower_bounds", "upper_bounds", "column_sizes");
    private static final List<String> SCAN_WITH_STATS_COLUMNS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(SCAN_COLUMNS)).addAll(STATS_COLUMNS)).build();
    protected static final List<String> DELETE_SCAN_COLUMNS = ImmutableList.of("snapshot_id", "content", "file_path", "file_ordinal", "file_format", "block_size_in_bytes", "file_size_in_bytes", "record_count", "partition", "key_metadata", "split_offsets");
    protected static final List<String> DELETE_SCAN_WITH_STATS_COLUMNS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(DELETE_SCAN_COLUMNS)).addAll(STATS_COLUMNS)).build();
    private static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);
    private final Table table;
    private final Schema schema;
    private final TableScanContext context;

    protected BaseScan(Table table, Schema schema, TableScanContext context) {
        this.table = table;
        this.schema = schema;
        this.context = context;
    }

    public Table table() {
        return this.table;
    }

    protected Schema tableSchema() {
        return this.schema;
    }

    protected TableScanContext context() {
        return this.context;
    }

    protected Map<String, String> options() {
        return this.context().options();
    }

    protected List<String> scanColumns() {
        return this.context.returnColumnStats() ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS;
    }

    protected boolean shouldIgnoreResiduals() {
        return this.context().ignoreResiduals();
    }

    protected boolean shouldPlanWithExecutor() {
        return PLAN_SCANS_WITH_WORKER_POOL || this.context().planWithCustomizedExecutor();
    }

    protected ExecutorService planExecutor() {
        return this.context().planExecutor();
    }

    protected abstract ThisT newRefinedScan(Table var1, Schema var2, TableScanContext var3);

    @Override
    public ThisT option(String property, String value) {
        return this.newRefinedScan(this.table, this.schema, this.context.withOption(property, value));
    }

    @Override
    public ThisT project(Schema projectedSchema) {
        return this.newRefinedScan(this.table, this.schema, this.context.project(projectedSchema));
    }

    @Override
    public ThisT caseSensitive(boolean caseSensitive) {
        return this.newRefinedScan(this.table, this.schema, this.context.setCaseSensitive(caseSensitive));
    }

    @Override
    public boolean isCaseSensitive() {
        return this.context().caseSensitive();
    }

    @Override
    public ThisT includeColumnStats() {
        return this.newRefinedScan(this.table, this.schema, this.context.shouldReturnColumnStats(true));
    }

    @Override
    public ThisT select(Collection<String> columns) {
        return this.newRefinedScan(this.table, this.schema, this.context.selectColumns(columns));
    }

    @Override
    public ThisT filter(Expression expr) {
        return this.newRefinedScan(this.table, this.schema, this.context.filterRows(Expressions.and(this.context.rowFilter(), expr)));
    }

    @Override
    public Expression filter() {
        return this.context().rowFilter();
    }

    @Override
    public ThisT ignoreResiduals() {
        return this.newRefinedScan(this.table, this.schema, this.context.ignoreResiduals(true));
    }

    @Override
    public ThisT planWith(ExecutorService executorService) {
        return this.newRefinedScan(this.table, this.schema, this.context.planWith(executorService));
    }

    @Override
    public Schema schema() {
        return BaseScan.lazyColumnProjection(this.context, this.schema);
    }

    @Override
    public long targetSplitSize() {
        long tableValue = PropertyUtil.propertyAsLong(this.table().properties(), "read.split.target-size", 0x8000000L);
        return PropertyUtil.propertyAsLong(this.context.options(), "read.split.target-size", tableValue);
    }

    @Override
    public int splitLookback() {
        int tableValue = PropertyUtil.propertyAsInt(this.table().properties(), "read.split.planning-lookback", 10);
        return PropertyUtil.propertyAsInt(this.context.options(), "read.split.planning-lookback", tableValue);
    }

    @Override
    public long splitOpenFileCost() {
        long tableValue = PropertyUtil.propertyAsLong(this.table().properties(), "read.split.open-file-cost", 0x400000L);
        return PropertyUtil.propertyAsLong(this.context.options(), "read.split.open-file-cost", tableValue);
    }

    private static Schema lazyColumnProjection(TableScanContext context, Schema schema) {
        Collection<String> selectedColumns = context.selectedColumns();
        if (selectedColumns != null) {
            HashSet<Integer> requiredFieldIds = Sets.newHashSet();
            requiredFieldIds.addAll(Binder.boundReferences(schema.asStruct(), Collections.singletonList(context.rowFilter()), context.caseSensitive()));
            Set<Integer> selectedIds = context.caseSensitive() ? TypeUtil.getProjectedIds(schema.select(selectedColumns)) : TypeUtil.getProjectedIds(schema.caseInsensitiveSelect(selectedColumns));
            requiredFieldIds.addAll(selectedIds);
            return TypeUtil.project(schema, requiredFieldIds);
        }
        if (context.projectedSchema() != null) {
            return context.projectedSchema();
        }
        return schema;
    }

    @Override
    public ThisT metricsReporter(MetricsReporter reporter) {
        return this.newRefinedScan(this.table(), this.schema(), this.context().reportWith(reporter));
    }
}

