/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFileIndex;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;

class ManifestGroup {
    private static final Types.StructType EMPTY_STRUCT = Types.StructType.of(new Types.NestedField[0]);
    private final FileIO io;
    private final Set<ManifestFile> dataManifests;
    private final DeleteFileIndex.Builder deleteIndexBuilder;
    private Predicate<ManifestFile> manifestPredicate;
    private Predicate<ManifestEntry<DataFile>> manifestEntryPredicate;
    private Map<Integer, PartitionSpec> specsById;
    private Expression dataFilter;
    private Expression fileFilter;
    private Expression partitionFilter;
    private boolean ignoreDeleted;
    private boolean ignoreExisting;
    private boolean ignoreResiduals;
    private List<String> columns;
    private boolean caseSensitive;
    private ExecutorService executorService;
    private ScanMetrics scanMetrics;

    ManifestGroup(FileIO io, Iterable<ManifestFile> manifests) {
        this(io, Iterables.filter(manifests, manifest -> manifest.content() == ManifestContent.DATA), Iterables.filter(manifests, manifest -> manifest.content() == ManifestContent.DELETES));
    }

    ManifestGroup(FileIO io, Iterable<ManifestFile> dataManifests, Iterable<ManifestFile> deleteManifests) {
        this.io = io;
        this.dataManifests = Sets.newHashSet(dataManifests);
        this.deleteIndexBuilder = DeleteFileIndex.builderFor(io, deleteManifests);
        this.dataFilter = Expressions.alwaysTrue();
        this.fileFilter = Expressions.alwaysTrue();
        this.partitionFilter = Expressions.alwaysTrue();
        this.ignoreDeleted = false;
        this.ignoreExisting = false;
        this.ignoreResiduals = false;
        this.columns = ManifestReader.ALL_COLUMNS;
        this.caseSensitive = true;
        this.manifestPredicate = m4 -> true;
        this.manifestEntryPredicate = e -> true;
        this.scanMetrics = ScanMetrics.noop();
    }

    ManifestGroup specsById(Map<Integer, PartitionSpec> newSpecsById) {
        this.specsById = newSpecsById;
        this.deleteIndexBuilder.specsById(newSpecsById);
        return this;
    }

    ManifestGroup filterData(Expression newDataFilter) {
        this.dataFilter = Expressions.and(this.dataFilter, newDataFilter);
        this.deleteIndexBuilder.filterData(newDataFilter);
        return this;
    }

    ManifestGroup filterFiles(Expression newFileFilter) {
        this.fileFilter = Expressions.and(this.fileFilter, newFileFilter);
        return this;
    }

    ManifestGroup filterPartitions(Expression newPartitionFilter) {
        this.partitionFilter = Expressions.and(this.partitionFilter, newPartitionFilter);
        this.deleteIndexBuilder.filterPartitions(newPartitionFilter);
        return this;
    }

    ManifestGroup filterManifests(Predicate<ManifestFile> newManifestPredicate) {
        this.manifestPredicate = this.manifestPredicate.and(newManifestPredicate);
        return this;
    }

    ManifestGroup filterManifestEntries(Predicate<ManifestEntry<DataFile>> newManifestEntryPredicate) {
        this.manifestEntryPredicate = this.manifestEntryPredicate.and(newManifestEntryPredicate);
        return this;
    }

    ManifestGroup scanMetrics(ScanMetrics metrics) {
        this.scanMetrics = metrics;
        return this;
    }

    ManifestGroup ignoreDeleted() {
        this.ignoreDeleted = true;
        return this;
    }

    ManifestGroup ignoreExisting() {
        this.ignoreExisting = true;
        return this;
    }

    ManifestGroup ignoreResiduals() {
        this.ignoreResiduals = true;
        return this;
    }

    ManifestGroup select(List<String> newColumns) {
        this.columns = Lists.newArrayList(newColumns);
        return this;
    }

    ManifestGroup caseSensitive(boolean newCaseSensitive) {
        this.caseSensitive = newCaseSensitive;
        this.deleteIndexBuilder.caseSensitive(newCaseSensitive);
        return this;
    }

    ManifestGroup planWith(ExecutorService newExecutorService) {
        this.executorService = newExecutorService;
        this.deleteIndexBuilder.planWith(newExecutorService);
        return this;
    }

    public CloseableIterable<FileScanTask> planFiles() {
        return this.plan(ManifestGroup::createFileScanTasks);
    }

    public <T extends ScanTask> CloseableIterable<T> plan(CreateTasksFunction<T> createTasksFunc) {
        LoadingCache<Integer, ResidualEvaluator> residualCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = this.specsById.get(specId);
            Expression filter = this.ignoreResiduals ? Expressions.alwaysTrue() : this.dataFilter;
            return ResidualEvaluator.of(spec, filter, this.caseSensitive);
        });
        DeleteFileIndex deleteFiles = this.deleteIndexBuilder.scanMetrics(this.scanMetrics).build();
        boolean dropStats = ManifestReader.dropStats(this.columns);
        if (!deleteFiles.isEmpty()) {
            this.select(ManifestReader.withStatsColumns(this.columns));
        }
        LoadingCache<Integer, TaskContext> taskContextCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = this.specsById.get(specId);
            ResidualEvaluator residuals = (ResidualEvaluator)residualCache.get((Integer)specId);
            return new TaskContext(spec, deleteFiles, residuals, dropStats, this.scanMetrics);
        });
        Iterable tasks = this.entries((manifest, entries) -> {
            int specId = manifest.partitionSpecId();
            TaskContext taskContext = (TaskContext)taskContextCache.get(specId);
            return createTasksFunc.apply((CloseableIterable<ManifestEntry<DataFile>>)entries, taskContext);
        });
        if (this.executorService != null) {
            return new ParallelIterable(tasks, this.executorService);
        }
        return CloseableIterable.concat(tasks);
    }

    public CloseableIterable<ManifestEntry<DataFile>> entries() {
        return CloseableIterable.concat(this.entries((manifest, entries) -> entries));
    }

    private <T> Iterable<CloseableIterable<T>> entries(BiFunction<ManifestFile, CloseableIterable<ManifestEntry<DataFile>>, CloseableIterable<T>> entryFn) {
        CloseableIterable<ManifestFile> matchingManifests;
        LoadingCache<Integer, ManifestEvaluator> evalCache = this.specsById == null ? null : Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = this.specsById.get(specId);
            return ManifestEvaluator.forPartitionFilter(Expressions.and(this.partitionFilter, Projections.inclusive(spec, this.caseSensitive).project(this.dataFilter)), spec, this.caseSensitive);
        });
        Evaluator evaluator = this.fileFilter != null && this.fileFilter != Expressions.alwaysTrue() ? new Evaluator(DataFile.getType(EMPTY_STRUCT), this.fileFilter, this.caseSensitive) : null;
        CloseableIterable<ManifestFile> closeableDataManifests = CloseableIterable.withNoopClose(this.dataManifests);
        CloseableIterable<ManifestFile> closeableIterable = matchingManifests = evalCache == null ? closeableDataManifests : CloseableIterable.filter(this.scanMetrics.skippedDataManifests(), closeableDataManifests, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
        if (this.ignoreDeleted) {
            matchingManifests = CloseableIterable.filter(this.scanMetrics.skippedDataManifests(), matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles());
        }
        if (this.ignoreExisting) {
            matchingManifests = CloseableIterable.filter(this.scanMetrics.skippedDataManifests(), matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasDeletedFiles());
        }
        matchingManifests = CloseableIterable.filter(this.scanMetrics.skippedDataManifests(), matchingManifests, this.manifestPredicate);
        matchingManifests = CloseableIterable.count(this.scanMetrics.scannedDataManifests(), matchingManifests);
        return Iterables.transform(matchingManifests, manifest -> new CloseableIterable<T>((ManifestFile)manifest, evaluator, entryFn){
            private CloseableIterable iterable;
            final /* synthetic */ ManifestFile val$manifest;
            final /* synthetic */ Evaluator val$evaluator;
            final /* synthetic */ BiFunction val$entryFn;
            {
                this.val$manifest = manifestFile;
                this.val$evaluator = evaluator;
                this.val$entryFn = biFunction;
            }

            @Override
            public CloseableIterator<T> iterator() {
                ManifestReader<DataFile> reader = ManifestFiles.read(this.val$manifest, ManifestGroup.this.io, ManifestGroup.this.specsById).filterRows(ManifestGroup.this.dataFilter).filterPartitions(ManifestGroup.this.partitionFilter).caseSensitive(ManifestGroup.this.caseSensitive).select(ManifestGroup.this.columns).scanMetrics(ManifestGroup.this.scanMetrics);
                CloseableIterable<ManifestEntry<DataFile>> entries = ManifestGroup.this.ignoreDeleted ? reader.liveEntries() : reader.entries();
                if (ManifestGroup.this.ignoreExisting) {
                    entries = CloseableIterable.filter(ManifestGroup.this.scanMetrics.skippedDataFiles(), entries, entry -> entry.status() != ManifestEntry.Status.EXISTING);
                }
                if (this.val$evaluator != null) {
                    entries = CloseableIterable.filter(ManifestGroup.this.scanMetrics.skippedDataFiles(), entries, entry -> this.val$evaluator.eval((GenericDataFile)entry.file()));
                }
                entries = CloseableIterable.filter(ManifestGroup.this.scanMetrics.skippedDataFiles(), entries, ManifestGroup.this.manifestEntryPredicate);
                this.iterable = (CloseableIterable)this.val$entryFn.apply(this.val$manifest, entries);
                return this.iterable.iterator();
            }

            @Override
            public void close() throws IOException {
                if (this.iterable != null) {
                    this.iterable.close();
                }
            }
        });
    }

    private static CloseableIterable<FileScanTask> createFileScanTasks(CloseableIterable<ManifestEntry<DataFile>> entries, TaskContext ctx) {
        return CloseableIterable.transform(entries, entry -> {
            DeleteFile[] deleteFiles;
            DataFile dataFile = (DataFile)((DataFile)entry.file()).copy(ctx.shouldKeepStats());
            for (DeleteFile deleteFile : deleteFiles = ctx.deletes().forEntry((ManifestEntry<DataFile>)entry)) {
                ctx.scanMetrics().totalDeleteFileSizeInBytes().increment(deleteFile.fileSizeInBytes());
            }
            ctx.scanMetrics().totalFileSizeInBytes().increment(dataFile.fileSizeInBytes());
            ctx.scanMetrics().resultDataFiles().increment();
            ctx.scanMetrics().resultDeleteFiles().increment((long)deleteFiles.length);
            return new BaseFileScanTask(dataFile, deleteFiles, ctx.schemaAsString(), ctx.specAsString(), ctx.residuals());
        });
    }

    static class TaskContext {
        private final String schemaAsString;
        private final String specAsString;
        private final DeleteFileIndex deletes;
        private final ResidualEvaluator residuals;
        private final boolean dropStats;
        private final ScanMetrics scanMetrics;

        TaskContext(PartitionSpec spec, DeleteFileIndex deletes, ResidualEvaluator residuals, boolean dropStats, ScanMetrics scanMetrics) {
            this.schemaAsString = SchemaParser.toJson(spec.schema());
            this.specAsString = PartitionSpecParser.toJson(spec);
            this.deletes = deletes;
            this.residuals = residuals;
            this.dropStats = dropStats;
            this.scanMetrics = scanMetrics;
        }

        String schemaAsString() {
            return this.schemaAsString;
        }

        String specAsString() {
            return this.specAsString;
        }

        DeleteFileIndex deletes() {
            return this.deletes;
        }

        ResidualEvaluator residuals() {
            return this.residuals;
        }

        boolean shouldKeepStats() {
            return !this.dropStats;
        }

        public ScanMetrics scanMetrics() {
            return this.scanMetrics;
        }
    }

    @FunctionalInterface
    static interface CreateTasksFunction<T extends ScanTask> {
        public CloseableIterable<T> apply(CloseableIterable<ManifestEntry<DataFile>> var1, TaskContext var2);
    }
}

