/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.GenericManifestEntry;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionSummary;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.V1Metadata;
import org.apache.iceberg.V2Metadata;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public abstract class ManifestWriter<F extends ContentFile<F>>
implements FileAppender<F> {
    static final long UNASSIGNED_SEQ = -1L;
    private final OutputFile file;
    private final int specId;
    private final FileAppender<ManifestEntry<F>> writer;
    private final Long snapshotId;
    private final GenericManifestEntry<F> reused;
    private final PartitionSummary stats;
    private boolean closed = false;
    private int addedFiles = 0;
    private long addedRows = 0L;
    private int existingFiles = 0;
    private long existingRows = 0L;
    private int deletedFiles = 0;
    private long deletedRows = 0L;
    private Long minDataSequenceNumber = null;

    private ManifestWriter(PartitionSpec spec, OutputFile file, Long snapshotId) {
        this.file = file;
        this.specId = spec.specId();
        this.writer = this.newAppender(spec, file);
        this.snapshotId = snapshotId;
        this.reused = new GenericManifestEntry(spec.partitionType());
        this.stats = new PartitionSummary(spec);
    }

    protected abstract ManifestEntry<F> prepare(ManifestEntry<F> var1);

    protected abstract FileAppender<ManifestEntry<F>> newAppender(PartitionSpec var1, OutputFile var2);

    protected ManifestContent content() {
        return ManifestContent.DATA;
    }

    void addEntry(ManifestEntry<F> entry) {
        switch (entry.status()) {
            case ADDED: {
                ++this.addedFiles;
                this.addedRows += entry.file().recordCount();
                break;
            }
            case EXISTING: {
                ++this.existingFiles;
                this.existingRows += entry.file().recordCount();
                break;
            }
            case DELETED: {
                ++this.deletedFiles;
                this.deletedRows += entry.file().recordCount();
            }
        }
        this.stats.update(entry.file().partition());
        if (entry.isLive() && entry.dataSequenceNumber() != null && (this.minDataSequenceNumber == null || entry.dataSequenceNumber() < this.minDataSequenceNumber)) {
            this.minDataSequenceNumber = entry.dataSequenceNumber();
        }
        this.writer.add(this.prepare(entry));
    }

    @Override
    public void add(F addedFile) {
        this.addEntry(this.reused.wrapAppend(this.snapshotId, addedFile));
    }

    public void add(F addedFile, long dataSequenceNumber) {
        this.addEntry(this.reused.wrapAppend(this.snapshotId, dataSequenceNumber, addedFile));
    }

    @Override
    void add(ManifestEntry<F> entry) {
        if (entry.dataSequenceNumber() != null && entry.dataSequenceNumber() >= 0L) {
            this.addEntry(this.reused.wrapAppend(this.snapshotId, entry.dataSequenceNumber(), entry.file()));
        } else {
            this.addEntry(this.reused.wrapAppend(this.snapshotId, entry.file()));
        }
    }

    public void existing(F existingFile, long fileSnapshotId, long dataSequenceNumber, Long fileSequenceNumber) {
        this.reused.wrapExisting(fileSnapshotId, dataSequenceNumber, fileSequenceNumber, existingFile);
        this.addEntry(this.reused);
    }

    void existing(ManifestEntry<F> entry) {
        this.addEntry(this.reused.wrapExisting(entry));
    }

    public void delete(F deletedFile, long dataSequenceNumber, Long fileSequenceNumber) {
        this.addEntry(this.reused.wrapDelete(this.snapshotId, dataSequenceNumber, fileSequenceNumber, deletedFile));
    }

    void delete(ManifestEntry<F> entry) {
        this.addEntry(this.reused.wrapDelete(this.snapshotId, entry));
    }

    @Override
    public Metrics metrics() {
        return this.writer.metrics();
    }

    @Override
    public long length() {
        return this.writer.length();
    }

    public ManifestFile toManifestFile() {
        Preconditions.checkState(this.closed, "Cannot build ManifestFile, writer is not closed");
        long minSeqNumber = this.minDataSequenceNumber != null ? this.minDataSequenceNumber : -1L;
        return new GenericManifestFile(this.file.location(), this.writer.length(), this.specId, this.content(), -1L, minSeqNumber, this.snapshotId, this.addedFiles, this.addedRows, this.existingFiles, this.existingRows, this.deletedFiles, this.deletedRows, this.stats.summaries(), null);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.writer.close();
    }

    static class V1Writer
    extends ManifestWriter<DataFile> {
        private final V1Metadata.IndexedManifestEntry entryWrapper;

        V1Writer(PartitionSpec spec, OutputFile file, Long snapshotId) {
            super(spec, file, snapshotId);
            this.entryWrapper = new V1Metadata.IndexedManifestEntry(spec.partitionType());
        }

        @Override
        protected ManifestEntry<DataFile> prepare(ManifestEntry<DataFile> entry) {
            return this.entryWrapper.wrap(entry);
        }

        @Override
        protected FileAppender<ManifestEntry<DataFile>> newAppender(PartitionSpec spec, OutputFile file) {
            Schema manifestSchema = V1Metadata.entrySchema(spec.partitionType());
            try {
                return Avro.write(file).schema(manifestSchema).named("manifest_entry").meta("schema", SchemaParser.toJson(spec.schema())).meta("partition-spec", PartitionSpecParser.toJsonFields(spec)).meta("partition-spec-id", String.valueOf(spec.specId())).meta("format-version", "1").overwrite().build();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create manifest writer for path: %s", file);
            }
        }
    }

    static class V2DeleteWriter
    extends ManifestWriter<DeleteFile> {
        private final V2Metadata.IndexedManifestEntry<DeleteFile> entryWrapper;

        V2DeleteWriter(PartitionSpec spec, OutputFile file, Long snapshotId) {
            super(spec, file, snapshotId);
            this.entryWrapper = new V2Metadata.IndexedManifestEntry(snapshotId, spec.partitionType());
        }

        @Override
        protected ManifestEntry<DeleteFile> prepare(ManifestEntry<DeleteFile> entry) {
            return this.entryWrapper.wrap(entry);
        }

        @Override
        protected FileAppender<ManifestEntry<DeleteFile>> newAppender(PartitionSpec spec, OutputFile file) {
            Schema manifestSchema = V2Metadata.entrySchema(spec.partitionType());
            try {
                return Avro.write(file).schema(manifestSchema).named("manifest_entry").meta("schema", SchemaParser.toJson(spec.schema())).meta("partition-spec", PartitionSpecParser.toJsonFields(spec)).meta("partition-spec-id", String.valueOf(spec.specId())).meta("format-version", "2").meta("content", "deletes").overwrite().build();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create manifest writer for path: %s", file);
            }
        }

        @Override
        protected ManifestContent content() {
            return ManifestContent.DELETES;
        }
    }

    static class V2Writer
    extends ManifestWriter<DataFile> {
        private final V2Metadata.IndexedManifestEntry<DataFile> entryWrapper;

        V2Writer(PartitionSpec spec, OutputFile file, Long snapshotId) {
            super(spec, file, snapshotId);
            this.entryWrapper = new V2Metadata.IndexedManifestEntry(snapshotId, spec.partitionType());
        }

        @Override
        protected ManifestEntry<DataFile> prepare(ManifestEntry<DataFile> entry) {
            return this.entryWrapper.wrap(entry);
        }

        @Override
        protected FileAppender<ManifestEntry<DataFile>> newAppender(PartitionSpec spec, OutputFile file) {
            Schema manifestSchema = V2Metadata.entrySchema(spec.partitionType());
            try {
                return Avro.write(file).schema(manifestSchema).named("manifest_entry").meta("schema", SchemaParser.toJson(spec.schema())).meta("partition-spec", PartitionSpecParser.toJsonFields(spec)).meta("partition-spec-id", String.valueOf(spec.specId())).meta("format-version", "2").meta("content", "data").overwrite().build();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to create manifest writer for path: %s", file);
            }
        }
    }
}

