/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.SplitScanTaskIterator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Ordering;

class OffsetsAwareSplitScanTaskIterator<T extends ScanTask>
implements SplitScanTaskIterator<T> {
    private static final Ordering<Comparable<Long>> OFFSET_ORDERING = Ordering.natural();
    private final T parentTask;
    private final SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator;
    private final List<Long> offsets;
    private final List<Long> splitSizes;
    private int splitIndex = 0;

    OffsetsAwareSplitScanTaskIterator(T parentTask, long parentTaskLength, List<Long> offsetList, SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator) {
        Preconditions.checkArgument(OFFSET_ORDERING.isStrictlyOrdered(offsetList), "Offsets must be sorted in asc order");
        this.parentTask = parentTask;
        this.splitTaskCreator = splitTaskCreator;
        this.offsets = ImmutableList.copyOf(offsetList);
        this.splitSizes = Lists.newArrayListWithCapacity(this.offsets.size());
        if (this.offsets.size() > 0) {
            int lastIndex = this.offsets.size() - 1;
            for (int index = 0; index < lastIndex; ++index) {
                this.splitSizes.add(this.offsets.get(index + 1) - this.offsets.get(index));
            }
            this.splitSizes.add(parentTaskLength - this.offsets.get(lastIndex));
        }
    }

    @Override
    public boolean hasNext() {
        return this.splitIndex < this.splitSizes.size();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        long offset = this.offsets.get(this.splitIndex);
        long splitSize = this.splitSizes.get(this.splitIndex);
        ++this.splitIndex;
        return this.splitTaskCreator.create(this.parentTask, offset, splitSize);
    }
}

