/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseScan;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.PartitionUtil;
import org.apache.iceberg.util.StructLikeMap;

public class PartitionsTable
extends BaseMetadataTable {
    private final Schema schema;
    private final boolean unpartitionedTable;

    PartitionsTable(Table table) {
        this(table, table.name() + ".partitions");
    }

    PartitionsTable(Table table, String name) {
        super(table, name);
        this.schema = new Schema(Types.NestedField.required(1, "partition", Partitioning.partitionType(table)), Types.NestedField.required(4, "spec_id", Types.IntegerType.get()), Types.NestedField.required(2, "record_count", Types.LongType.get(), "Count of records in data files"), Types.NestedField.required(3, "file_count", Types.IntegerType.get(), "Count of data files"), Types.NestedField.required(5, "position_delete_record_count", Types.LongType.get(), "Count of records in position delete files"), Types.NestedField.required(6, "position_delete_file_count", Types.IntegerType.get(), "Count of position delete files"), Types.NestedField.required(7, "equality_delete_record_count", Types.LongType.get(), "Count of records in equality delete files"), Types.NestedField.required(8, "equality_delete_file_count", Types.IntegerType.get(), "Count of equality delete files"));
        this.unpartitionedTable = Partitioning.partitionType(table).fields().isEmpty();
    }

    @Override
    public TableScan newScan() {
        return new PartitionsScan(this.table());
    }

    @Override
    public Schema schema() {
        if (this.unpartitionedTable) {
            return this.schema.select("record_count", "file_count", "position_delete_record_count", "position_delete_file_count", "equality_delete_record_count", "equality_delete_file_count");
        }
        return this.schema;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.PARTITIONS;
    }

    private DataTask task(StaticTableScan scan) {
        Iterable<Partition> partitions = PartitionsTable.partitions(this.table(), scan);
        if (this.unpartitionedTable) {
            return StaticDataTask.of(this.io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), partitions, root -> StaticDataTask.Row.of(((Partition)root).dataRecordCount, ((Partition)root).dataFileCount, ((Partition)root).posDeleteRecordCount, ((Partition)root).posDeleteFileCount, ((Partition)root).eqDeleteRecordCount, ((Partition)root).eqDeleteFileCount));
        }
        return StaticDataTask.of(this.io().newInputFile(this.table().operations().current().metadataFileLocation()), this.schema(), scan.schema(), partitions, PartitionsTable::convertPartition);
    }

    private static StaticDataTask.Row convertPartition(Partition partition) {
        return StaticDataTask.Row.of(partition.partitionData, partition.specId, partition.dataRecordCount, partition.dataFileCount, partition.posDeleteRecordCount, partition.posDeleteFileCount, partition.eqDeleteRecordCount, partition.eqDeleteFileCount);
    }

    private static Iterable<Partition> partitions(Table table, StaticTableScan scan) {
        Types.StructType partitionType = Partitioning.partitionType(table);
        PartitionMap partitions = new PartitionMap(partitionType);
        try (CloseableIterable<ContentFile<?>> files = PartitionsTable.planFiles(scan);){
            for (ContentFile contentFile : files) {
                StructLike partition = PartitionUtil.coercePartition(partitionType, table.specs().get(contentFile.specId()), contentFile.partition());
                partitions.get(partition).update(contentFile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return partitions.all();
    }

    @VisibleForTesting
    static CloseableIterable<ContentFile<?>> planFiles(StaticTableScan scan) {
        Table table = scan.table();
        CloseableIterable<ManifestFile> filteredManifests = PartitionsTable.filteredManifests(scan, table, scan.snapshot().allManifests(table.io()));
        CloseableIterable<CloseableIterable> tasks = CloseableIterable.transform(filteredManifests, manifest -> CloseableIterable.transform(ManifestFiles.open(manifest, table.io(), table.specs()).caseSensitive(scan.isCaseSensitive()).select(PartitionsTable.scanColumns(manifest.content())), t2 -> t2));
        return new ParallelIterable(tasks, scan.planExecutor());
    }

    private static List<String> scanColumns(ManifestContent content) {
        switch (content) {
            case DATA: {
                return BaseScan.SCAN_COLUMNS;
            }
            case DELETES: {
                return BaseScan.DELETE_SCAN_COLUMNS;
            }
        }
        throw new UnsupportedOperationException("Cannot read unknown manifest type: " + (Object)((Object)content));
    }

    private static CloseableIterable<ManifestFile> filteredManifests(StaticTableScan scan, Table table, List<ManifestFile> manifestFilesList) {
        CloseableIterable<ManifestFile> manifestFiles = CloseableIterable.withNoopClose(manifestFilesList);
        LoadingCache<Integer, ManifestEvaluator> evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = table.specs().get(specId);
            PartitionSpec transformedSpec = PartitionsTable.transformSpec(scan.tableSchema(), spec);
            return ManifestEvaluator.forRowFilter(scan.filter(), transformedSpec, scan.isCaseSensitive());
        });
        return CloseableIterable.filter(manifestFiles, manifest -> ((ManifestEvaluator)evalCache.get(manifest.partitionSpecId())).eval((ManifestFile)manifest));
    }

    static class Partition {
        private final PartitionData partitionData;
        private int specId;
        private long dataRecordCount;
        private int dataFileCount;
        private long posDeleteRecordCount;
        private int posDeleteFileCount;
        private long eqDeleteRecordCount;
        private int eqDeleteFileCount;

        Partition(StructLike key, Types.StructType keyType) {
            this.partitionData = this.toPartitionData(key, keyType);
            this.specId = 0;
            this.dataRecordCount = 0L;
            this.dataFileCount = 0;
            this.posDeleteRecordCount = 0L;
            this.posDeleteFileCount = 0;
            this.eqDeleteRecordCount = 0L;
            this.eqDeleteFileCount = 0;
        }

        void update(ContentFile<?> file) {
            switch (file.content()) {
                case DATA: {
                    this.dataRecordCount += file.recordCount();
                    ++this.dataFileCount;
                    this.specId = file.specId();
                    break;
                }
                case POSITION_DELETES: {
                    this.posDeleteRecordCount = file.recordCount();
                    ++this.posDeleteFileCount;
                    this.specId = file.specId();
                    break;
                }
                case EQUALITY_DELETES: {
                    this.eqDeleteRecordCount = file.recordCount();
                    ++this.eqDeleteFileCount;
                    this.specId = file.specId();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported file content type: " + (Object)((Object)file.content()));
                }
            }
        }

        private PartitionData toPartitionData(StructLike key, Types.StructType keyType) {
            PartitionData data = new PartitionData(keyType);
            for (int i = 0; i < keyType.fields().size(); ++i) {
                Object val = key.get(i, keyType.fields().get(i).type().typeId().javaClass());
                if (val == null) continue;
                data.set(i, val);
            }
            return data;
        }
    }

    static class PartitionMap {
        private final StructLikeMap<Partition> partitions;
        private final Types.StructType keyType;

        PartitionMap(Types.StructType type) {
            this.partitions = StructLikeMap.create(type);
            this.keyType = type;
        }

        Partition get(StructLike key) {
            Partition partition = this.partitions.get(key);
            if (partition == null) {
                partition = new Partition(key, this.keyType);
                this.partitions.put(key, partition);
            }
            return partition;
        }

        Iterable<Partition> all() {
            return this.partitions.values();
        }
    }

    private class PartitionsScan
    extends StaticTableScan {
        PartitionsScan(Table table) {
            super(table, PartitionsTable.this.schema(), MetadataTableType.PARTITIONS, (StaticTableScan x$0) -> PartitionsTable.this.task(x$0));
        }
    }
}

