/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.ByteBuffers;

class SerializableByteBufferMap
implements Map<Integer, ByteBuffer>,
Serializable {
    private final Map<Integer, ByteBuffer> wrapped;

    static Map<Integer, ByteBuffer> wrap(Map<Integer, ByteBuffer> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof SerializableByteBufferMap) {
            return map;
        }
        return new SerializableByteBufferMap(map);
    }

    SerializableByteBufferMap() {
        this.wrapped = Maps.newLinkedHashMap();
    }

    private SerializableByteBufferMap(Map<Integer, ByteBuffer> wrapped) {
        this.wrapped = wrapped;
    }

    Object writeReplace() throws ObjectStreamException {
        Set<Map.Entry<Integer, ByteBuffer>> entries = this.wrapped.entrySet();
        int[] keys = new int[entries.size()];
        byte[][] values = new byte[keys.length][];
        int keyIndex = 0;
        for (Map.Entry entry : entries) {
            keys[keyIndex] = (Integer)entry.getKey();
            values[keyIndex] = ByteBuffers.toByteArray((ByteBuffer)entry.getValue());
            ++keyIndex;
        }
        return new MapSerializationProxy(keys, values);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public ByteBuffer get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public ByteBuffer put(Integer key, ByteBuffer value) {
        return this.wrapped.put(key, value);
    }

    @Override
    public ByteBuffer remove(Object key) {
        return this.wrapped.remove(key);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends ByteBuffer> m4) {
        this.wrapped.putAll(m4);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public Set<Integer> keySet() {
        return this.wrapped.keySet();
    }

    @Override
    public Collection<ByteBuffer> values() {
        return this.wrapped.values();
    }

    @Override
    public Set<Map.Entry<Integer, ByteBuffer>> entrySet() {
        return this.wrapped.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    private static class MapSerializationProxy
    implements Serializable {
        private int[] keys = null;
        private byte[][] values = null;

        MapSerializationProxy() {
        }

        MapSerializationProxy(int[] keys, byte[][] values) {
            this.keys = keys;
            this.values = values;
        }

        Object readResolve() throws ObjectStreamException {
            LinkedHashMap<Integer, ByteBuffer> map = Maps.newLinkedHashMap();
            for (int i = 0; i < this.keys.length; ++i) {
                map.put(this.keys[i], ByteBuffer.wrap(this.values[i]));
            }
            return SerializableByteBufferMap.wrap(map);
        }
    }
}

