/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.Bucket;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.Days;
import org.apache.iceberg.transforms.Hours;
import org.apache.iceberg.transforms.Identity;
import org.apache.iceberg.transforms.Months;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Truncate;
import org.apache.iceberg.transforms.UnknownTransform;
import org.apache.iceberg.transforms.VoidTransform;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;

public class Transforms {
    private static final Pattern HAS_WIDTH = Pattern.compile("(\\w+)\\[(\\d+)\\]");

    private Transforms() {
    }

    public static Transform<?, ?> fromString(String transform) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transform);
        if (widthMatcher.matches()) {
            String name = widthMatcher.group(1);
            int parsedWidth = Integer.parseInt(widthMatcher.group(2));
            if (name.equalsIgnoreCase("truncate")) {
                return Truncate.get(parsedWidth);
            }
            if (name.equalsIgnoreCase("bucket")) {
                return Bucket.get(parsedWidth);
            }
        }
        if (transform.equalsIgnoreCase("identity")) {
            return Identity.get();
        }
        if (transform.equalsIgnoreCase("year")) {
            return Years.get();
        }
        if (transform.equalsIgnoreCase("month")) {
            return Months.get();
        }
        if (transform.equalsIgnoreCase("day")) {
            return Days.get();
        }
        if (transform.equalsIgnoreCase("hour")) {
            return Hours.get();
        }
        if (transform.equalsIgnoreCase("void")) {
            return VoidTransform.get();
        }
        return new UnknownTransform(transform);
    }

    public static Transform<?, ?> fromString(Type type, String transform) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transform);
        if (widthMatcher.matches()) {
            String name = widthMatcher.group(1);
            int parsedWidth = Integer.parseInt(widthMatcher.group(2));
            if (name.equalsIgnoreCase("truncate")) {
                return Truncate.get(type, parsedWidth);
            }
            if (name.equalsIgnoreCase("bucket")) {
                return Bucket.get(type, parsedWidth);
            }
        }
        if (transform.equalsIgnoreCase("identity")) {
            return Identity.get(type);
        }
        try {
            if (type.typeId() == Type.TypeID.TIMESTAMP) {
                return Timestamps.valueOf(transform.toUpperCase(Locale.ENGLISH));
            }
            if (type.typeId() == Type.TypeID.DATE) {
                return Dates.valueOf(transform.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (transform.equalsIgnoreCase("void")) {
            return VoidTransform.get();
        }
        return new UnknownTransform(transform);
    }

    @Deprecated
    public static <T> Transform<T, T> identity(Type type) {
        return Identity.get(type);
    }

    @Deprecated
    public static <T> Transform<T, Integer> year(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.YEAR;
            }
            case TIMESTAMP: {
                return Timestamps.YEAR;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by year");
    }

    @Deprecated
    public static <T> Transform<T, Integer> month(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.MONTH;
            }
            case TIMESTAMP: {
                return Timestamps.MONTH;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by month");
    }

    @Deprecated
    public static <T> Transform<T, Integer> day(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.DAY;
            }
            case TIMESTAMP: {
                return Timestamps.DAY;
            }
        }
        throw new IllegalArgumentException("Cannot partition type " + type + " by day");
    }

    @Deprecated
    public static <T> Transform<T, Integer> hour(Type type) {
        Preconditions.checkArgument(type.typeId() == Type.TypeID.TIMESTAMP, "Cannot partition type %s by hour", (Object)type);
        return Timestamps.HOUR;
    }

    @Deprecated
    public static <T> Transform<T, Integer> bucket(Type type, int numBuckets) {
        return Bucket.get(type, numBuckets);
    }

    @Deprecated
    public static <T> Transform<T, T> truncate(Type type, int width) {
        return Truncate.get(type, width);
    }

    public static <T> Transform<T, T> identity() {
        return Identity.get();
    }

    public static <T> Transform<T, Integer> year() {
        return Years.get();
    }

    public static <T> Transform<T, Integer> month() {
        return Months.get();
    }

    public static <T> Transform<T, Integer> day() {
        return Days.get();
    }

    public static <T> Transform<T, Integer> hour() {
        return Hours.get();
    }

    public static <T> Transform<T, Integer> bucket(int numBuckets) {
        return Bucket.get(numBuckets);
    }

    public static <T> Transform<T, T> truncate(int width) {
        return Truncate.get(width);
    }

    public static <T> Transform<T, Void> alwaysNull() {
        return VoidTransform.get();
    }
}

