/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class ReassignDoc
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema docSourceSchema;

    ReassignDoc(Schema docSourceSchema) {
        this.docSourceSchema = docSourceSchema;
    }

    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> fieldTypes) {
        List<Types.NestedField> fields = struct.fields();
        int length = fields.size();
        ArrayList<Type> types = Lists.newArrayList(fieldTypes);
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(length);
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            int fieldId = field.fieldId();
            Types.NestedField docField = this.docSourceSchema.findField(fieldId);
            Preconditions.checkNotNull(docField, "Field " + fieldId + " not found in source schema");
            if (field.isRequired()) {
                newFields.add(Types.NestedField.required(fieldId, field.name(), (Type)types.get(i), docField.doc()));
                continue;
            }
            newFields.add(Types.NestedField.optional(fieldId, field.name(), (Type)types.get(i), docField.doc()));
        }
        return Types.StructType.of(newFields);
    }

    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type list(Types.ListType list, Supplier<Type> elementTypeFuture) {
        Type elementType = elementTypeFuture.get();
        if (list.elementType() == elementType) {
            return list;
        }
        if (list.isElementOptional()) {
            return Types.ListType.ofOptional(list.elementId(), elementType);
        }
        return Types.ListType.ofRequired(list.elementId(), elementType);
    }

    @Override
    public Type map(Types.MapType map, Supplier<Type> keyTypeFuture, Supplier<Type> valueTypeFuture) {
        int keyId = map.keyId();
        int valueId = map.valueId();
        Type keyType = keyTypeFuture.get();
        Type valueType = valueTypeFuture.get();
        if (map.isValueOptional()) {
            return Types.MapType.ofOptional(keyId, valueId, keyType, valueType);
        }
        return Types.MapType.ofRequired(keyId, valueId, keyType, valueType);
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

