/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ViewHistoryEntry", generator="Immutables")
@Immutable
public final class ImmutableViewHistoryEntry
implements ViewHistoryEntry {
    private final long timestampMillis;
    private final int versionId;

    private ImmutableViewHistoryEntry(long timestampMillis, int versionId) {
        this.timestampMillis = timestampMillis;
        this.versionId = versionId;
    }

    @Override
    public long timestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public int versionId() {
        return this.versionId;
    }

    public final ImmutableViewHistoryEntry withTimestampMillis(long value) {
        if (this.timestampMillis == value) {
            return this;
        }
        return new ImmutableViewHistoryEntry(value, this.versionId);
    }

    public final ImmutableViewHistoryEntry withVersionId(int value) {
        if (this.versionId == value) {
            return this;
        }
        return new ImmutableViewHistoryEntry(this.timestampMillis, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewHistoryEntry && this.equalTo(0, (ImmutableViewHistoryEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableViewHistoryEntry another) {
        return this.timestampMillis == another.timestampMillis && this.versionId == another.versionId;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Long.hashCode(this.timestampMillis);
        h2 += (h2 << 5) + this.versionId;
        return h2;
    }

    public String toString() {
        return "ViewHistoryEntry{timestampMillis=" + this.timestampMillis + ", versionId=" + this.versionId + "}";
    }

    public static ImmutableViewHistoryEntry copyOf(ViewHistoryEntry instance) {
        if (instance instanceof ImmutableViewHistoryEntry) {
            return (ImmutableViewHistoryEntry)instance;
        }
        return ImmutableViewHistoryEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewHistoryEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIMESTAMP_MILLIS = 1L;
        private static final long INIT_BIT_VERSION_ID = 2L;
        private long initBits = 3L;
        private long timestampMillis;
        private int versionId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ViewHistoryEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.timestampMillis(instance.timestampMillis());
            this.versionId(instance.versionId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestampMillis(long timestampMillis) {
            this.timestampMillis = timestampMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder versionId(int versionId) {
            this.versionId = versionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableViewHistoryEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableViewHistoryEntry(this.timestampMillis, this.versionId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timestampMillis");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("versionId");
            }
            return "Cannot build ViewHistoryEntry, some of required attributes are not set " + attributes;
        }
    }
}

