/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.view.ViewRepresentation;
import org.immutables.value.Value;

@Value.Immutable
public interface ViewVersion {
    public int versionId();

    public long timestampMillis();

    public Map<String, String> summary();

    public List<ViewRepresentation> representations();

    @Value.Lazy
    default public String operation() {
        return this.summary().get("operation");
    }

    public int schemaId();

    @Value.Check
    default public void check() {
        Preconditions.checkArgument(this.summary().containsKey("operation"), "Invalid view version summary, missing operation");
    }
}

