/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.v2.params;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.api.v2.params.ParsedReference;
import org.projectnessie.model.Reference;

@ParametersAreNonnullByDefault
@Generated(from="ParsedReference", generator="Immutables")
@Immutable
public final class ImmutableParsedReference
implements ParsedReference {
    private final String name;
    private final String hash;
    private final Reference.ReferenceType type;

    private ImmutableParsedReference(String name, String hash, Reference.ReferenceType type) {
        this.name = name;
        this.hash = hash;
        this.type = type;
    }

    private ImmutableParsedReference(ImmutableParsedReference original, String name, String hash, Reference.ReferenceType type) {
        this.name = name;
        this.hash = hash;
        this.type = type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String hash() {
        return this.hash;
    }

    @Override
    public Reference.ReferenceType type() {
        return this.type;
    }

    public final ImmutableParsedReference withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return ImmutableParsedReference.validate(new ImmutableParsedReference(this, value, this.hash, this.type));
    }

    public final ImmutableParsedReference withHash(String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableParsedReference.validate(new ImmutableParsedReference(this, this.name, value, this.type));
    }

    public final ImmutableParsedReference withType(Reference.ReferenceType value) {
        if (this.type == value) {
            return this;
        }
        return ImmutableParsedReference.validate(new ImmutableParsedReference(this, this.name, this.hash, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParsedReference && this.equalTo(0, (ImmutableParsedReference)another);
    }

    private boolean equalTo(int synthetic, ImmutableParsedReference another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.hash, another.hash) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.name);
        h2 += (h2 << 5) + Objects.hashCode(this.hash);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.type);
        return h2;
    }

    public String toString() {
        return "ParsedReference{name=" + this.name + ", hash=" + this.hash + ", type=" + (Object)((Object)this.type) + "}";
    }

    public static ImmutableParsedReference of(String name, String hash, Reference.ReferenceType type) {
        return ImmutableParsedReference.validate(new ImmutableParsedReference(name, hash, type));
    }

    private static ImmutableParsedReference validate(ImmutableParsedReference instance) {
        instance.check();
        return instance;
    }

    public static ImmutableParsedReference copyOf(ParsedReference instance) {
        if (instance instanceof ImmutableParsedReference) {
            return (ImmutableParsedReference)instance;
        }
        return ImmutableParsedReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ParsedReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String hash;
        @Nullable
        private Reference.ReferenceType type;

        private Builder() {
        }

        public final Builder from(ParsedReference instance) {
            Reference.ReferenceType typeValue;
            String hashValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((hashValue = instance.hash()) != null) {
                this.hash(hashValue);
            }
            if ((typeValue = instance.type()) != null) {
                this.type(typeValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final Builder type(Reference.ReferenceType type) {
            this.type = type;
            return this;
        }

        public ImmutableParsedReference build() {
            return ImmutableParsedReference.validate(new ImmutableParsedReference(null, this.name, this.hash, this.type));
        }
    }
}

